# frozen_string_literal: true

class AddTemporaryIndexForVulnerabilityReadsClusterAgentIdMigration < Gitlab::Database::Migration[2.0]
  INDEX_VULNERABILITY_READS_NAME = 'tmp_index_cis_vulnerability_reads_on_id'

  disable_ddl_transaction!

  def up
    # this index is used in 20220525221133_schedule_backfill_vulnerability_reads_cluster_agent
    add_concurrent_index :vulnerability_reads, :id, name: INDEX_VULNERABILITY_READS_NAME, where: 'report_type = 7'
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_VULNERABILITY_READS_NAME
  end
end
