# frozen_string_literal: true

RSpec.shared_examples 'service account creation success' do
  it 'creates a service account successfully', :aggregate_failures do
    result = service.execute

    expect(result.status).to eq(:success)
    expect(result.payload.confirmed?).to eq(true)
    expect(result.payload.user_type).to eq('service_account')
  end

  include_examples 'username and email pair is generated by Gitlab::Utils::UsernameAndEmailGenerator' do
    subject { service.execute.payload }

    let(:email_domain) { "noreply.#{Gitlab.config.gitlab.host}" }
  end
end
