# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityScanners::ListService, feature_category: :vulnerability_management do
  let_it_be(:group) { create(:group) }
  let_it_be(:project) { create(:project, group: group) }
  let_it_be(:vulnerability_scanner) { create(:vulnerabilities_scanner, project: project, id: 123) }
  let_it_be(:vulnerability_finding) { create(:vulnerabilities_finding, project: project, scanner: vulnerability_scanner) }

  let(:service) { described_class.new(vulnerable) }

  subject(:scanner_list) { service.execute }

  context 'when looking for scanners for group' do
    let(:vulnerable) { group }

    it { is_expected.to eq([{ id: 123, vendor: "Security Vendor", report_type: "SAST" }]) }
  end

  context 'when looking for scanners for project' do
    let(:vulnerable) { project }

    it { is_expected.to eq([{ id: 123, vendor: "Security Vendor", report_type: "SAST" }]) }
  end
end
