# frozen_string_literal: true

require 'spec_helper'

RSpec.describe VulnerabilityNoteEntity do
  include Gitlab::Routing

  let(:request) { double('request', current_user: user, noteable: note.noteable) }

  let(:entity) { described_class.new(note, request: request) }
  let(:project) { create(:project) }
  let(:vulnerability) { create(:vulnerability, project: project, author: user) }
  let(:note) { create(:note, project: project, noteable: vulnerability, author: user) }
  let(:user) { create(:user) }

  subject { entity.as_json }

  it_behaves_like 'note entity'

  it 'exposes vulnerability-specific elements' do
    expect(subject).to include(:toggle_award_path, :path)
  end
end
