# frozen_string_literal: true

require 'spec_helper'
require_migration!

RSpec.describe RemoveVulnerabilityApprovalRules, feature_category: :vulnerability_management do
  let(:namespaces) { table(:namespaces) }
  let(:namespace) { namespaces.create!(name: 'foo', path: 'foo') }
  let(:projects) { table(:projects) }
  let(:project) { projects.create!(namespace_id: namespace.id, project_namespace_id: namespace.id) }
  let(:approval_project_rules) { table(:approval_project_rules) }
  let!(:vulnerability_rule) do
    approval_project_rules.create!(name: 'Vulnerability-Check', report_type: 1, rule_type: 2, project_id: project.id)
  end

  let!(:code_coverage_rule) do
    approval_project_rules.create!(name: 'Coverage-Check', report_type: 3, rule_type: 2, project_id: project.id)
  end

  describe '#up' do
    it 'deletes the vulnerability rule' do
      expect { migrate! }.to change(ApprovalProjectRule, :count).from(2).to(1)
    end
  end
end
