# frozen_string_literal: true

require 'spec_helper'

RSpec.describe ::EE::API::Entities::Vulnerability do
  let_it_be(:project) { create(:project, :with_vulnerability) }

  let(:vulnerability) { project.vulnerabilities.first }

  subject { described_class.new(vulnerability).as_json }

  before do
    create(:vulnerabilities_finding, vulnerability: vulnerability)
  end

  it 'contains vulnerability properties' do
    expect(subject[:id]).to eq(vulnerability.id)
    expect(subject[:title]).to eq(vulnerability.title)
    expect(subject[:description]).to eq(vulnerability.description)

    expect(subject[:state]).to eq(vulnerability.state)
    expect(subject[:severity]).to eq(vulnerability.severity)
    expect(subject[:confidence]).to eq(vulnerability.confidence)
    expect(subject[:report_type]).to eq(vulnerability.report_type)

    expect(subject[:project][:id]).to eq(vulnerability.project_id)

    expect(subject[:finding]['id']).to eq(vulnerability.finding_ids.last)
    expect(subject[:resolved_on_default_branch]).to eq(vulnerability.resolved_on_default_branch)
    expect(subject[:project_default_branch]).to eq(vulnerability.project_default_branch)

    expect(subject[:author_id]).to eq(vulnerability.author_id)
    expect(subject[:updated_by_id]).to eq(vulnerability.updated_by_id)
    expect(subject[:last_edited_by_id]).to eq(vulnerability.last_edited_by_id)
    expect(subject[:resolved_by_id]).to eq(vulnerability.resolved_by_id)
    expect(subject[:dismissed_by_id]).to eq(vulnerability.dismissed_by_id)
    expect(subject[:confirmed_by_id]).to eq(vulnerability.confirmed_by_id)

    expect(subject[:start_date]).to eq(vulnerability.start_date)
    expect(subject[:due_date]).to eq(vulnerability.due_date)

    expect(subject[:created_at]).to eq(vulnerability.created_at)
    expect(subject[:updated_at]).to eq(vulnerability.updated_at)
    expect(subject[:last_edited_at]).to eq(vulnerability.last_edited_at)
    expect(subject[:resolved_at]).to eq(vulnerability.resolved_at)
    expect(subject[:dismissed_at]).to eq(vulnerability.dismissed_at)
    expect(subject[:confirmed_at]).to eq(vulnerability.confirmed_at)
  end
end
