# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Types::PermissionTypes::Vulnerability do
  it do
    expected_permissions = %i[read_vulnerability_feedback create_vulnerability_feedback destroy_vulnerability_feedback
                              update_vulnerability_feedback create_vulnerability create_vulnerability_export
                              admin_vulnerability admin_vulnerability_issue_link admin_vulnerability_external_issue_link]

    expected_permissions.each do |permission|
      expect(described_class).to have_graphql_field(permission)
    end
  end
end
