# frozen_string_literal: true

class CreateVulnerabilityExportRegistry < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    unless table_exists?(:vulnerability_export_registry)
      create_table :vulnerability_export_registry, id: :bigserial, force: :cascade do |t|
        t.datetime_with_timezone :retry_at
        t.datetime_with_timezone :last_synced_at
        t.datetime_with_timezone :created_at, null: false
        t.bigint :vulnerability_export_id, null: false
        t.integer :state, default: 0, null: false, limit: 2
        t.integer :retry_count, default: 0, limit: 2
        t.text :last_sync_failure

        t.index :vulnerability_export_id, name: :index_vulnerability_export_registry_on_vulnerability_export_id, unique: true
        t.index :retry_at
        t.index :state
      end
    end

    add_text_limit :vulnerability_export_registry, :last_sync_failure, 255
  end

  def down
    return unless table_exists?(:vulnerability_export_registry)

    drop_table :vulnerability_export_registry
  end
end
