# frozen_string_literal: true

module Types
  module VulnerabilityLocation
    # Vulnerability locations have their authorization enforced by VulnerabilityType
    # rubocop: disable Graphql/AuthorizeTypes
    class ClusterImageScanningType < ContainerScanningType
      graphql_name 'VulnerabilityLocationClusterImageScanning'
      description 'Represents the location of a vulnerability found by a cluster image scan'

      field :kubernetes_resource,
            ::Types::VulnerableKubernetesResourceType,
            null: true,
            description: 'Kubernetes resource which uses the vulnerable container image.'
    end
  end
end
