# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class UrlType < BaseType
      graphql_name 'VulnerabilityDetailUrl'
      description 'Represents the vulnerability details URL field'

      field :text, GraphQL::Types::String, null: true, description: 'Text of the URL.'

      field :href, GraphQL::Types::String, null: false, description: 'Href of the URL.'
    end
  end
end
