# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class CodeType < BaseType
      graphql_name 'VulnerabilityDetailCode'
      description 'Represents the vulnerability details code field'

      field :lang, GraphQL::Types::String, null: true, description: 'Language of the code.'

      field :value, GraphQL::Types::String, null: false, description: 'Source code.'
    end
  end
end
