# frozen_string_literal: true

module Types
  module Vulnerability
    class IssueLinkTypeEnum < BaseEnum
      graphql_name 'VulnerabilityIssueLinkType'
      description 'The type of the issue link related to a vulnerability'

      ::Vulnerabilities::IssueLink.link_types.keys.each do |link_type|
        description = case link_type.to_sym
                      when :created then 'Issue is created for the vulnerability'
                      when :related then 'Has a related issue'
                      else
                        link_type.to_s.titleize
                      end

        value link_type.to_s.upcase, value: link_type.to_s, description: description
      end
    end
  end
end
