import { SEVERITY_LEVELS_GRAPHQL } from 'ee/security_dashboard/store/constants';
import { REPORT_TYPES } from './constants';
import VulnerabilityDetailsGraphql from './index.vue';

const VULNERABILITY_STATES = ['CONFIRMED', 'DETECTED', 'DISMISSED', 'RESOLVED'];

export default {
  component: VulnerabilityDetailsGraphql,
  title: 'ee/security_dashboard/components/shared/vulnerability_details_graphql/index.vue',
  argTypes: {
    severity: {
      options: SEVERITY_LEVELS_GRAPHQL,
      control: { type: 'select' },
    },
    reportType: {
      options: REPORT_TYPES,
      control: { type: 'select' },
    },
    state: {
      options: VULNERABILITY_STATES,
      control: { type: 'select' },
    },
  },
};

const Template = (args, { argTypes }) => ({
  components: { VulnerabilityDetailsGraphql },
  props: Object.keys(argTypes),
  template: '<vulnerability-details-graphql v-bind="$props" />',
});

export const Default = Template.bind({});
Default.args = {
  description: 'Generic Object Injection Sink',
  severity: SEVERITY_LEVELS_GRAPHQL[0],
  state: VULNERABILITY_STATES[0],
  project: {
    name: 'GitLab.com',
    webUrl: 'http://gitlab.com',
  },
  location: {
    file: '/src/js/main.js',
    blobPath: '/project/namespace/-/blob/e3343434/src/js/main.js',
    startLine: '10',
    endLine: '20',
  },
  reportType: REPORT_TYPES[0],
  links: [
    {
      name: 'CVE-2018-1000544',
      url: 'https://nvd.nist.gov/vuln/detail/CVE-2018-1000544',
    },
    {
      url: 'https://github.com/advisories/GHSA-xh29-r2w5-wx8m',
    },
  ],
  identifiers: [
    {
      name: 'Gemnasium-7e9c16eb-d4ee-4c0a-a3b7-ed88f1ea7125',
      url:
        'https://gitlab.com/gitlab-org/security-products/gemnasium-db/-/blob/master/gem/nokogiri/CVE-2019-5477.yml',
    },
    {
      name: 'Gitleaks rule ID PGP-PK',
    },
  ],
  scanner: {
    name: 'ESLint',
    version: '8.26.0',
  },
  assets: [
    {
      name: 'Asset 1',
      url: 'http://gitlab.com/asset-1',
    },
    {
      name: 'Asset 2',
    },
  ],
};
