---
type: reference, howto
stage: Govern
group: Threat Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# View vulnerabilities in a pipeline

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/13496) in GitLab 12.3.

To view vulnerabilities in a pipeline:

1. On the top bar, select **Main menu > Projects** and find your project.
1. On the left sidebar, select **CI/CD > Pipelines**.
1. From the list, select the pipeline you want to check for vulnerabilities.
1. Select the **Security** tab.

A pipeline consists of multiple jobs, which may include security scans. When a job declares and produces security scan
reports using [`artifacts:reports`](../../../ci/yaml/artifacts_reports.md), GitLab parses and ingests the contents of
these reports to create vulnerabilities associated with the project the pipeline belongs to.

If a job fails to finish, the pipeline vulnerability report doesn't show vulnerability findings detected by this job.
For example, if a pipeline contains DAST and SAST jobs, but the DAST job fails by returning a non-zero
[exit code](../../../development/integrations/secure.md#exit-code), the report doesn't show DAST results.

The pipeline vulnerability report only shows results contained in the security report artifacts. This report differs from
the [Vulnerability Report](index.md), which contains cumulative results of all successful jobs, and from the merge request
[security widget](../index.md#view-security-scan-information-in-merge-requests), which combines the branch results with
cumulative results.

Before GitLab displays results, the vulnerability findings in all pipeline reports are [deduplicated](#deduplication-process).

## Scan details

**Scan details** shows a summary of vulnerability findings in the pipeline and the source reports.

GitLab displays one row of information for each [scan type](../terminology/index.md#scan-type-report-type) artifact present in
the pipeline.

Each scan type's total number of vulnerabilities includes dismissed findings. If the number of findings
in the report doesn't match the number in **Scan details**, ensure that **Hide dismissed** is disabled.

### Download security scan outputs

> - [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/3728) in GitLab 13.10.
> - [Improved](https://gitlab.com/gitlab-org/gitlab/-/issues/333660) in GitLab 14.2.

Depending on the type of security scanner, you can download:

- A JSON artifact that contains the security scanner [report](../../../development/integrations/secure.md#report).
- A CSV file that contains URLs and endpoints scanned by the security scanner.

To download a security scan output:

1. In **Scan details**, select **Download results**:
    - To download a JSON file, select the JSON artifact.
    - To download a CSV file, select **Download scanned resources**.

## Scan results

This shows a list of the combined results for all security report artifacts. The filters work like the
[Vulnerability Report filters](index.md#vulnerability-report-filters), but they are limited to **Severity** and **Tool**, with
the addition of a **Hide dismissed** toggle.

When you review the vulnerability findings reported in the pipeline, you can select one or more entries for dismissal,
similar to [Dismissing a vulnerability](index.md#dismiss-a-vulnerability) in the Vulnerability Report.

When you merge the branch corresponding to the pipeline into the default branch, all reported findings are combined into
the [Vulnerability Report](index.md). Scan results in pipelines executed on the default branch are
incorporated once the pipeline finishes.

| Existing vulnerability status | Dismissed in pipeline? | New vulnerability status |
|:------------------------------|:-----------------------|:-------------------------|
| any                           | Yes                    | Dismissed                |
| Dismissed                     | any                    | Dismissed                |
| Confirmed                     | No                     | Confirmed                |
| Needs triage (Detected)       | No                     | Needs triage (Detected)  |
| Resolved                      | No                     | Needs triage (Detected)  |
| N/A (That is: new vulnerability) | No                     | Needs triage (Detected)  |

## Retention period for vulnerabilities

> [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/351524) in GitLab 15.5.

GitLab has the following retention policies for vulnerabilities on non-default branches. Vulnerabilities are no longer available:

- When the related CI job artifact expires.
- 90 days after the pipeline is created, even if the related CI job artifacts are locked.

To view vulnerabilities, either:

- Run a new pipeline.
- Download the related CI job artifacts if they are available.

NOTE:
This does not apply for the vulnerabilities existing on the default branch.

## Deduplication process

When a pipeline contains jobs that produce multiple security reports of the same type, it is possible that the same
vulnerability finding is present in multiple reports. This duplication is common when different scanners are used to
increase coverage, but can also exist within a single report. The deduplication process allows you to maximize the vulnerability scanning coverage while reducing
the number of findings you need to manage.

A finding is considered a duplicate of another finding when their [scan type](../terminology/index.md#scan-type-report-type),
[location](../terminology/index.md#location-fingerprint), and one or more of its
[identifiers](../../../development/integrations/secure.md#identifiers) are the same.

The scan type must match because each can have its own definition for the location of a vulnerability. For example,
static analyzers are able to locate a file path and line number, whereas a container scanning analyzer uses the image
name instead.

When comparing identifiers, GitLab does not compare `CWE` and `WASC` during deduplication because they are
"type identifiers" and are used to classify groups of vulnerabilities. Including these identifiers would result in
many findings being incorrectly considered duplicates. Two findings are considered unique if none of their
identifiers match.

In a set of duplicated findings, the first occurrence of a finding is kept and the remaining are skipped. Security
reports are processed in alphabetical file path order, and findings are processed sequentially in the order they
appear in a report.

### Deduplication examples

- Example 1: matching identifiers and location, mismatching scan type.
  - Finding
    - Scan type: `sast`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2022-25510
  - Other Finding
    - Scan type: `secret_detection`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2022-25510
  - Deduplication result: not duplicates because the scan type is different.
- Example 2: matching location and scan type, mismatching type identifiers.
  - Finding
    - Scan type: `sast`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CWE-259
  - Other Finding
    - Scan type: `sast`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CWE-798
  - Deduplication result: duplicates because `CWE` identifiers are ignored.
- Example 3: matching scan type, location and an identifier.
  - Finding
    - Scan type: `container_scanning`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2019-12345, CVE-2022-25510, CWE-259
  - Other Finding
    - Scan type: `container_scanning`
    - Location fingerprint: `adc83b19e793491b1c6ea0fd8b46cd9f32e592fc`
    - Identifiers: CVE-2022-25510, CWE-798
  - Deduplication result: duplicates because all criteria match, and type identifiers are ignored.
    Only one identifier needs to match, in this case CVE-2022-25510.

The examples above don't include the raw location values. Each scan type defines its own
`fingerprint_data`, which is used to generate a `SHA1` hash that is used as the `location_fingerprint`.
You can find definitions for each scan type [`gitlab/lib/gitlab/ci/reports/security/locations`](https://gitlab.com/gitlab-org/gitlab/-/tree/01c69e97340b7c1c7e30c0caec8506910b6503c8/lib/gitlab/ci/reports/security/locations)
and [`gitlab/ee/lib/gitlab/ci/reports/security/locations`](https://gitlab.com/gitlab-org/gitlab/-/tree/01c69e97340b7c1c7e30c0caec8506910b6503c8/ee/lib/gitlab/ci/reports/security/locations).
