# frozen_string_literal: true

class RescheduleRecalculateVulnerabilityFindingSignaturesForFindings < Gitlab::Database::Migration[1.0]
  MIGRATION = 'RecalculateVulnerabilityFindingSignaturesForFindings'
  BATCH_SIZE = 1_000
  DELAY_INTERVAL = 2.minutes

  disable_ddl_transaction!

  # Due to production incident previous migration was orphaned and must be rescheduled,
  # See https://gitlab.com/gitlab-org/gitlab/-/merge_requests/72919#note_741188600
  def up
    return unless Gitlab.ee?

    delete_queued_jobs(MIGRATION)

    requeue_background_migration_jobs_by_range_at_intervals(
      MIGRATION,
      DELAY_INTERVAL,
      batch_size: BATCH_SIZE
    )
  end

  def down
    # no-op
  end
end
