# frozen_string_literal: true

module EE
  module Gitlab
    module BackgroundMigration
      module DeleteApprovalRulesWithVulnerability
        extend ActiveSupport::Concern
        extend ::Gitlab::Utils::Override

        prepended do
          scope_to -> (relation) { relation.where(report_type: 1) }
          operation_name :delete_all
        end

        override :perform
        def perform
          # rubocop:disable Style/SymbolProc
          each_sub_batch do |sub_batch|
            sub_batch.delete_all
          end
          # rubocop:enable Style/SymbolProc
        end
      end
    end
  end
end
