# frozen_string_literal: true

module EE
  module Banzai
    module ReferenceParser
      module VulnerabilityParser
        def references_relation
          Vulnerability
        end

        def records_for_nodes(nodes)
          @vulnerabilities_for_nodes ||= grouped_objects_for_nodes(
            nodes,
            ::Vulnerability.with_author_and_project,
            self.class.data_attribute
          )
        end

        def can_read_reference?(user, vulnerability)
          can?(user, :read_security_resource, vulnerability)
        end
      end
    end
  end
end
