# frozen_string_literal: true

class VulnerabilityNoteEntity < NoteEntity
  expose :toggle_award_path, if: -> (note, _) { note.emoji_awardable? } do |note|
    toggle_award_emoji_project_security_vulnerability_note_path(note.noteable.project, note.noteable, note)
  end

  expose :path, if: -> (note, _) { note.noteable } do |note|
    project_security_vulnerability_note_path(note.noteable.project, note.noteable, note)
  end
end
