# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityRequestType < BaseObject
    graphql_name 'VulnerabilityRequest'
    description 'Represents a Vulnerability Request'

    field :body, GraphQL::Types::String,
      null: true, description: 'Body of the Vulnerability Request.'

    # GraphQL Ruby has the following bug https://github.com/rmosolgo/graphql-ruby/issues/3944 which prevents
    # using the `hash_key` attribute if the source field is named `method`. We can work around this by using
    # the `resolver_method` instead, however, there's a rubocop rule which forces us to use the `hash_key`
    # method, so we need to disable this rule until the previously mentioned bug is fixed.
    field :method, GraphQL::Types::String,
      null: true, # rubocop: disable GraphQL/FieldHashKey
      # this is necessary to avoid the error "VulnerabilityRequest's `field :method` conflicts with a built-in method"
      resolver_method: :resolve_method,
      description: 'Method of the Vulnerability Request.'

    field :url, GraphQL::Types::String,
      null: true, description: 'URL of the Vulnerability Request.'

    field :headers, [VulnerabilityRequestResponseHeaderType],
      null: false, description: 'HTTP headers of the Vulnerability Request.'

    def resolve_method
      object[:method]
    end
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
