# frozen_string_literal: true

module Types
  module VulnerabilityDetails
    # rubocop: disable Graphql/AuthorizeTypes
    class FileLocationType < BaseType
      graphql_name 'VulnerabilityDetailFileLocation'
      description 'Represents the vulnerability details location within a file in the project'

      field :file_name, GraphQL::Types::String,
        null: false, description: 'File name.'

      field :line_start, GraphQL::Types::Int,
        null: false, description: 'Start line number of the file location.'

      field :line_end, GraphQL::Types::Int,
        null: false, description: 'End line number of the file location.'
    end
  end
end
