# frozen_string_literal: true

module Types
  class VulnerabilityConfidenceEnum < BaseEnum
    graphql_name 'VulnerabilityConfidence'
    description 'Confidence that a given vulnerability is present in the codebase.'

    ::Enums::Vulnerability.confidence_levels.keys.each do |confidence_level|
      value confidence_level.to_s.upcase, value: confidence_level.to_s, description: "#{confidence_level.to_s.titleize} confidence"
    end
  end
end
