# frozen_string_literal: true

module Types
  module Vulnerability
    class StateTransitionType < BaseObject
      graphql_name 'VulnerabilityStateTransitionType'

      description 'Represents a state transition of a vulnerability'

      authorize :read_security_resource

      field :from_state, VulnerabilityStateEnum,
        null: false, description: 'State of the vulnerability before transition.'

      field :to_state, VulnerabilityStateEnum,
        null: false, description: 'State of the vulnerability after transition.'

      field :comment, GraphQL::Types::String,
        null: true, description: 'Comment for the state change.'

      field :dismissal_reason, Types::Vulnerabilities::DismissalReasonEnum,
        null: true, description: 'Reason for the dismissal.'

      field :author, ::Types::UserType,
        null: false, description: 'User who changed the state of the vulnerability.'

      field :created_at, ::Types::TimeType,
        null: false, description: 'Time of the state change of the vulnerability.'
    end
  end
end
