# frozen_string_literal: true

module Mutations
  module VulnerabilityStateTransitions
    extend ActiveSupport::Concern

    prepended do
      argument :comment,
        GraphQL::Types::String,
        required: false,
        description: "Comment why vulnerability was #{state_transition_name_past_tense} (maximum 50,000 characters)."

      field :vulnerability, Types::VulnerabilityType,
        null: true,
        description: 'Vulnerability after state change.'

      argument :id,
        ::Types::GlobalIDType[::Vulnerability],
        required: true,
        description: "ID of the vulnerability to be #{state_transition_name_past_tense}."

      authorize :admin_vulnerability

      def resolve(id:, comment: nil)
        vulnerability = authorized_find!(id: id)
        result = transition_vulnerability(vulnerability, comment)

        {
          vulnerability: result,
          errors: result.errors.full_messages || []
        }
      end
    end
  end
end
