import { __, s__ } from '~/locale';
import {
  stateFilter,
  severityFilter,
  activityFilter,
  clusterFilter,
  imageFilter,
  projectFilter,
  simpleScannerFilter,
  simpleScannerFilterPipeline,
  vendorScannerFilter,
} from 'ee/security_dashboard/helpers';
import { REPORT_TYPES_WITH_MANUALLY_ADDED } from 'ee/security_dashboard/store/constants';
import { REPORT_TYPE_CLUSTER_IMAGE_SCANNING } from '~/vue_shared/security_reports/constants';

export const FIELDS = {
  CHECKBOX: {
    key: 'checkbox',
    class: 'checkbox',
  },
  DETECTED: {
    key: 'detected',
    label: s__('Vulnerability|Detected'),
    class: 'detected',
    sortable: true,
  },
  STATUS: {
    key: 'state',
    label: s__('Vulnerability|Status'),
    class: 'status',
  },
  SEVERITY: {
    key: 'severity',
    label: s__('Vulnerability|Severity'),
    class: 'severity',
    sortable: true,
  },
  DESCRIPTION: {
    key: 'title',
    label: __('Description'),
    class: 'description gl-word-break-all',
  },
  IDENTIFIER: {
    key: 'identifier',
    label: s__('Vulnerability|Identifier'),
    class: 'identifier gl-word-break-all',
  },
  TOOL: {
    key: 'reportType',
    label: s__('Reports|Tool'),
    class: 'scanner',
  },
  CLUSTER: {
    key: 'cluster',
    label: s__('Vulnerability|Cluster'),
    thClass: 'gl-w-15p',
    class: 'cluster gl-word-break-all',
  },
  ACTIVITY: {
    key: 'activity',
    label: s__('Vulnerability|Activity'),
    thClass: 'gl-text-right',
    class: 'activity',
  },
};

export const FILTERS = {
  STATUS: stateFilter,
  SEVERITY: severityFilter,
  ACTIVITY: activityFilter,
  IMAGE: imageFilter,
  TOOL_SIMPLE: simpleScannerFilter,
  TOOL_VENDOR: vendorScannerFilter,
  TOOL_PIPELINE: simpleScannerFilterPipeline,
  PROJECT: projectFilter,
  CLUSTER: clusterFilter,
};

const BASE_FIELDS = {
  START: [FIELDS.DETECTED, FIELDS.STATUS, FIELDS.SEVERITY, FIELDS.DESCRIPTION],
  END: [FIELDS.ACTIVITY],
};

export const FIELD_PRESETS = {
  DEVELOPMENT: [...BASE_FIELDS.START, FIELDS.IDENTIFIER, FIELDS.TOOL, ...BASE_FIELDS.END],
  OPERATIONAL: [...BASE_FIELDS.START, FIELDS.CLUSTER, ...BASE_FIELDS.END],
  AGENT: [...BASE_FIELDS.START, ...BASE_FIELDS.END],
};

const BASE_FILTERS = { START: [FILTERS.STATUS, FILTERS.SEVERITY], END: [FILTERS.ACTIVITY] };

export const FILTER_PRESETS = {
  DEVELOPMENT_PROJECT: [...BASE_FILTERS.START, FILTERS.TOOL_VENDOR, ...BASE_FILTERS.END],
  DEVELOPMENT: [...BASE_FILTERS.START, FILTERS.TOOL_SIMPLE, FILTERS.PROJECT, ...BASE_FILTERS.END],
  OPERATIONAL_PROJECT: [...BASE_FILTERS.START, FILTERS.CLUSTER, FILTERS.IMAGE, ...BASE_FILTERS.END],
  OPERATIONAL: [...BASE_FILTERS.START, FILTERS.PROJECT, ...BASE_FILTERS.END],
  AGENT: [...BASE_FILTERS.START, FILTERS.IMAGE, ...BASE_FILTERS.END],
};

export const REPORT_TYPE_PRESETS = {
  DEVELOPMENT: Object.keys(REPORT_TYPES_WITH_MANUALLY_ADDED).map((type) => type.toUpperCase()),
  OPERATIONAL: [REPORT_TYPE_CLUSTER_IMAGE_SCANNING.toUpperCase()],
};
