---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
type: reference
---

# Configure your GitLab installation **(FREE SELF)**

Customize and configure your self-managed GitLab installation.

- [Authentication](auth/index.md)
- [CI/CD](../administration/cicd.md)
- [Configuration](../user/admin_area/index.md)
- [Consul](../administration/consul.md)
- [Environment variables](../administration/environment_variables.md)
- [File hooks](../administration/file_hooks.md)
- [Git protocol v2](../administration/git_protocol.md)
- [Incoming email](../administration/incoming_email.md)
- [Instance limits](../administration/instance_limits.md)
- [Instance Review](../administration/instance_review.md)
- [PostgreSQL](../administration/postgresql/index.md)
- [Load balancer](../administration/load_balancer.md)
- [NFS](../administration/nfs.md)
- [Postfix](../administration/reply_by_email_postfix_setup.md)
- [Redis](../administration/redis/index.md)
- [Sidekiq](../administration/sidekiq/index.md)
- [S/MIME signing](../administration/smime_signing_email.md)
- [Repository storage](../administration/repository_storage_paths.md)
- [Object storage](../administration/object_storage.md)
- [Merge request diffs storage](../administration/merge_request_diffs.md)
- [Static objects external storage](../administration/static_objects_external_storage.md)
- [Geo](../administration/geo/index.md)
- [Disaster recovery (Geo)](../administration/geo/disaster_recovery/index.md)
- [Agent server for Kubernetes](../administration/clusters/kas.md)
- [Server hooks](../administration/server_hooks.md)
- [Terraform state](../administration/terraform_state.md)
- [Terraform limits](../user/admin_area/settings/terraform_limits.md)
- [Packages](../administration/packages/index.md)
- [Web terminals](../administration/integration/terminal.md)
- [Wikis](../administration/wikis/index.md)
- [Invalidate Markdown cache](../administration/invalidate_markdown_cache.md)
- [Issue closing pattern](../administration/issue_closing_pattern.md)
- [Snippets](../administration/snippets/index.md)
- [Host the product documentation](../administration/docs_self_host.md)
