# frozen_string_literal: true

class PrepareIndexForVulnerabilityReadsOnProjectIdScannerIdVulnerabilityId < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = 'idx_vulnerability_reads_project_id_scanner_id_vulnerability_id'

  # Index to be created synchronously in https://gitlab.com/gitlab-org/gitlab/-/issues/382625
  def up
    prepare_async_index :vulnerability_reads, [:project_id, :scanner_id, :vulnerability_id], name: INDEX_NAME
  end

  def down
    unprepare_async_index :vulnerability_reads, [:project_id, :scanner_id, :vulnerability_id], name: INDEX_NAME
  end
end
