# frozen_string_literal: true

class AddForeignKeyOnVulnerabilityReadsNamespaceId < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :vulnerability_reads, :namespaces, column: :namespace_id, on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key_if_exists :vulnerability_reads, column: :namespace_id
    end
  end
end
