# frozen_string_literal: true

class PopulateVulnerabilityReads < Gitlab::Database::Migration[1.0]
  BATCH_SIZE = 10_000
  DELAY_INTERVAL = 2.minutes
  MIGRATION_NAME = 'PopulateVulnerabilityReads'
  SUB_BATCH_SIZE = 1_000

  disable_ddl_transaction!

  def up
    queue_background_migration_jobs_by_range_at_intervals(
      define_batchable_model('vulnerabilities'),
      MIGRATION_NAME,
      DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      track_jobs: true,
      other_job_arguments: [SUB_BATCH_SIZE]
    )
  end

  def down
    # no-op
  end
end
