# frozen_string_literal: true

class ChangeVulnerabilityFeedbackUniqueIdx < Gitlab::Database::Migration[2.0]
  NEW_INDEX_NAME = :index_vulnerability_feedback_on_common_attributes
  OLD_INDEX_NAME = :vulnerability_feedback_unique_idx

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_feedback,
                         %i[project_id category feedback_type project_fingerprint],
                         name: NEW_INDEX_NAME

    remove_concurrent_index_by_name :vulnerability_feedback, OLD_INDEX_NAME
  end

  def down
    add_concurrent_index :vulnerability_feedback,
                         %i[project_id category feedback_type project_fingerprint],
                         name: OLD_INDEX_NAME,
                         unique: true

    remove_concurrent_index_by_name :vulnerability_feedback, NEW_INDEX_NAME
  end
end
