# frozen_string_literal: true

class AddVulnerabilityRelatedColumns < Gitlab::Database::Migration[2.0]
  def change
    add_column :approval_merge_request_rules,
      :vulnerabilities_allowed,
      :integer,
      limit: 2,
      null: false,
      default: 0
    add_column :approval_merge_request_rules,
      :scanners,
      :text,
      array: true,
      null: false,
      default: []
    add_column :approval_merge_request_rules,
      :severity_levels,
      :text,
      array: true,
      null: false,
      default: []
    add_column :approval_merge_request_rules,
      :vulnerability_states,
      :text,
      array: true,
      null: false,
      default: ['newly_detected']
  end
end
