import { placeholderImage } from '~/lazy_loader';
import { defaultMarkdownSerializer } from '~/lib/prosemirror_markdown_serializer';
import { HIGHER_PARSE_RULE_PRIORITY } from '../constants';

export default () => ({
  name: 'image',
  schema: {
    attrs: {
      src: {},
      alt: {
        default: null,
      },
      title: {
        default: null,
      },
    },
    group: 'inline',
    inline: true,
    draggable: true,
    parseDOM: [
      // Matches HTML generated by Banzai::Filter::ImageLinkFilter
      {
        tag: 'a.no-attachment-icon',
        priority: HIGHER_PARSE_RULE_PRIORITY,
        skip: true,
      },
      // Matches HTML generated by Banzai::Filter::ImageLazyLoadFilter
      {
        tag: 'img[src]:not(.emoji)',
        getAttrs: (el) => {
          const imageSrc = el.src;
          const imageUrl =
            imageSrc && imageSrc !== placeholderImage ? imageSrc : el.dataset.src || '';

          return {
            src: imageUrl,
            title: el.getAttribute('title'),
            alt: el.getAttribute('alt'),
          };
        },
      },
    ],
    toDOM: (node) => ['img', node.attrs],
  },
  toMarkdown(state, node) {
    defaultMarkdownSerializer.nodes.image(state, node);
  },
});
