# frozen_string_literal: true

require 'spec_helper'

RSpec.describe GitlabSchema.types['VulnerabilityStateTransitionType'], feature_category: :vulnerability_management do
  let(:expected_fields) { %i[from_state to_state comment dismissal_reason author created_at] }

  subject { described_class }

  it { is_expected.to have_graphql_fields(expected_fields) }
  it { is_expected.to require_graphql_authorizations(:read_security_resource) }
end
