import { screen, within } from '@testing-library/dom';
import { setHTMLFixture, resetHTMLFixture } from 'helpers/fixtures';
import initNewVulnerability from 'ee/vulnerabilities/new_vulnerability_init';

describe('New Vulnerability Form', () => {
  let vm;
  let container;

  const createComponent = () => {
    const el = document.createElement('div');

    Object.assign(el.dataset, {
      markdownDocsPath: '/markdown/docs/path',
      markdownPreviewPath: '/markdown/preview/path',
    });

    container.appendChild(el);
    return initNewVulnerability(el);
  };

  beforeEach(() => {
    setHTMLFixture('<div class="new-vulnerability-init"></div>');
    container = document.querySelector('.new-vulnerability-init');
    vm = createComponent(container);
  });

  afterEach(() => {
    vm.$destroy();
    resetHTMLFixture();
  });

  it('renders the form', () => {
    const form = screen.getByTestId('new-vulnerability-form');
    expect(within(form).getByText('Add vulnerability finding')).toBeInstanceOf(HTMLElement);
  });
});
