import { GlFormTextarea } from '@gitlab/ui';
import { mountExtended } from 'helpers/vue_test_utils_helper';
import MarkdownField from '~/vue_shared/components/markdown/field.vue';
import SectionSolution from 'ee/vulnerabilities/components/new_vulnerability/section_solution.vue';

describe('New vulnerability - Section Solution', () => {
  const markdownDocsPath = '/path/to/markdown/docs';
  const markdownPreviewPath = '/path/to/markdown/preview';

  let wrapper;

  const createWrapper = () => {
    return mountExtended(SectionSolution, {
      provide: {
        markdownDocsPath,
        markdownPreviewPath,
      },
    });
  };

  beforeEach(() => {
    wrapper = createWrapper();
  });

  it('creates markdown editor with correct props', () => {
    expect(wrapper.findComponent(MarkdownField).props()).toMatchObject({
      markdownDocsPath,
      markdownPreviewPath,
      textareaValue: '',
      canAttachFile: false,
      addSpacingClasses: false,
      isSubmitting: false,
      restrictedToolBarItems: ['attach-file'],
    });
  });

  it('emits the changes for the markdown field', () => {
    const solution = 'The solution of the vulnerability';
    const component = wrapper.findComponent(GlFormTextarea);
    component.vm.$emit('input', solution);
    component.vm.$emit('change', solution);
    expect(wrapper.emitted('change')[0][0]).toEqual({ solution });
  });
});
