import ActivityFilter from 'ee/security_dashboard/components/shared/filters/activity_filter.vue';
import ActivityFilterDeprecated from 'ee/security_dashboard/components/shared/filters/activity_filter_deprecated.vue';
import ClusterFilter from 'ee/security_dashboard/components/shared/filters/cluster_filter.vue';
import ClusterFilterDeprecated from 'ee/security_dashboard/components/shared/filters/cluster_filter_deprecated.vue';
import ImageFilter from 'ee/security_dashboard/components/shared/filters/image_filter.vue';
import ImageFilterDeprecated from 'ee/security_dashboard/components/shared/filters/image_filter_deprecated.vue';
import VulnerabilityFilters from 'ee/security_dashboard/components/shared/vulnerability_report/vulnerability_filters.vue';
import ProjectFilter from 'ee/security_dashboard/components/shared/filters/project_filter.vue';
import ProjectFilterDeprecated from 'ee/security_dashboard/components/shared/filters/project_filter_deprecated.vue';
import ScannerFilter from 'ee/security_dashboard/components/shared/filters/scanner_filter.vue';
import SeverityFilter from 'ee/security_dashboard/components/shared/filters/severity_filter.vue';
import SimpleFilter from 'ee/security_dashboard/components/shared/filters/simple_filter.vue';
import StatusFilter from 'ee/security_dashboard/components/shared/filters/status_filter.vue';
import ToolFilter from 'ee/security_dashboard/components/shared/filters/tool_filter.vue';
import ToolWithVendorFilter from 'ee/security_dashboard/components/shared/filters/tool_with_vendor_filter.vue';
import { shallowMountExtended } from 'helpers/vue_test_utils_helper';
import { FILTERS } from 'ee/security_dashboard/components/shared/vulnerability_report/constants';

const { ACTIVITY, CLUSTER, PROJECT, SEVERITY, STATUS, TOOL_SIMPLE, TOOL_VENDOR, IMAGE } = FILTERS;

describe('Vulnerability filters component', () => {
  let wrapper;

  const createWrapper = ({
    filters,
    refactorVulnerabilityToolFilter = true,
    refactorVulnerabilityFilters = true,
  }) => {
    wrapper = shallowMountExtended(VulnerabilityFilters, {
      propsData: { filters },
      provide: {
        glFeatures: {
          refactorVulnerabilityToolFilter,
          refactorVulnerabilityFilters,
        },
      },
    });
  };

  it('emits filters-changed event when filter is changed', () => {
    createWrapper({ filters: [STATUS] });
    const filter = wrapper.findComponent(StatusFilter);
    const data = { a: 1 };
    filter.vm.$emit('filter-changed', data);

    expect(wrapper.emitted('filters-changed')[0][0]).toMatchObject(data);
  });

  it.each`
    name                             | filters          | expectedComponent           | refactorVulnerabilityFilters
    ${'activity deprecated'}         | ${[ACTIVITY]}    | ${ActivityFilterDeprecated} | ${false}
    ${'activity'}                    | ${[ACTIVITY]}    | ${ActivityFilter}           | ${true}
    ${'project deprecated'}          | ${[PROJECT]}     | ${ProjectFilterDeprecated}  | ${false}
    ${'project'}                     | ${[PROJECT]}     | ${ProjectFilter}            | ${true}
    ${'severity deprecated'}         | ${[SEVERITY]}    | ${SimpleFilter}             | ${false}
    ${'severity'}                    | ${[SEVERITY]}    | ${SeverityFilter}           | ${true}
    ${'status deprecated'}           | ${[STATUS]}      | ${SimpleFilter}             | ${false}
    ${'status'}                      | ${[STATUS]}      | ${StatusFilter}             | ${true}
    ${'tool simple'}                 | ${[TOOL_SIMPLE]} | ${ToolFilter}               | ${false}
    ${'tool with vendor deprecated'} | ${[TOOL_VENDOR]} | ${ScannerFilter}            | ${false}
    ${'tool with vendor'}            | ${[TOOL_VENDOR]} | ${ToolWithVendorFilter}     | ${true}
    ${'cluster'}                     | ${[CLUSTER]}     | ${ClusterFilter}            | ${true}
    ${'cluster deprecated'}          | ${[CLUSTER]}     | ${ClusterFilterDeprecated}  | ${false}
    ${'image'}                       | ${[IMAGE]}       | ${ImageFilter}              | ${true}
    ${'image deprecated'}            | ${[IMAGE]}       | ${ImageFilterDeprecated}    | ${false}
  `(
    `shows the expected component for filter '$name'`,
    ({ filters, expectedComponent, refactorVulnerabilityFilters }) => {
      createWrapper({ filters, refactorVulnerabilityFilters });

      expect(wrapper.findComponent(expectedComponent).exists()).toBe(true);
    },
  );

  describe('when the "refactorVulnerabilityToolFilter" and "refactorVulnerabilityFilters" feature flag are disabled', () => {
    it.each`
      name             | filters          | expectedComponent
      ${'tool_simple'} | ${[TOOL_SIMPLE]} | ${SimpleFilter}
    `(`shows the expected component for filter '$name'`, ({ filters, expectedComponent }) => {
      createWrapper({
        filters,
        refactorVulnerabilityToolFilter: false,
        refactorVulnerabilityFilters: false,
      });

      expect(wrapper.findComponent(expectedComponent).exists()).toBe(true);
    });
  });
});
