# frozen_string_literal: true

module VulnerabilityScanners
  class ListService < BaseService
    def initialize(vulnerable)
      @vulnerable = vulnerable
    end

    def execute
      @vulnerable
        .vulnerability_scanners
        .with_report_type
        .map do |scanner|
        {
          id: scanner.id,
          vendor: scanner.vendor,
          report_type: ::Enums::Vulnerability.report_types.key(scanner.report_type).upcase
        }
      end
    end
  end
end
