# frozen_string_literal: true

module EE
  module Enums
    module Vulnerability
      extend ActiveSupport::Concern

      REPORT_TYPES = {
        dependency_scanning: 1,
        container_scanning: 2,
        dast: 3,
        coverage_fuzzing: 5,
        api_fuzzing: 6,
        cluster_image_scanning: 7,
        generic: 99
      }.freeze

      class_methods do
        extend ::Gitlab::Utils::Override

        override :report_types
        def report_types
          @report_types ||= super.merge(REPORT_TYPES).sort_by(&:last).to_h.with_indifferent_access.freeze
        end
      end
    end
  end
end
