# frozen_string_literal: true

module Types
  # rubocop: disable Graphql/AuthorizeTypes
  class VulnerabilityRequestResponseHeaderType < BaseObject
    graphql_name 'VulnerabilityRequestResponseHeader'
    description 'Represents a Vulnerability Request/Response Header'

    field :name, GraphQL::Types::String,
      null: true, description: 'Name of the Vulnerability Request/Response Header.'

    field :value, GraphQL::Types::String,
      null: true, description: 'Value of the Vulnerability Request/Response Header.'
  end
  # rubocop: enable Graphql/AuthorizeTypes
end
