# frozen_string_literal: true

class RecreateAsyncTrigramIndexForVulnerabilityReadsContainerImages < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_reads_on_location_image_trigram'
  REPORT_TYPES = { container_scanning: 2, cluster_image_scanning: 7 }.freeze

  def up
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME

    prepare_async_index :vulnerability_reads, :location_image,
      name: INDEX_NAME,
      using: :gin, opclass: { location_image: :gin_trgm_ops },
      where: "report_type = ANY (ARRAY[#{REPORT_TYPES.values.join(', ')}]) AND location_image IS NOT NULL"
  end

  def down
    unprepare_async_index :vulnerability_reads, :location_image, name: INDEX_NAME
  end
end
