# frozen_string_literal: true

class DeleteMigrateSharedVulnerabilityScanners < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_main

  MIGRATION = "MigrateSharedVulnerabilityScanners"
  TABLE_NAME = :vulnerability_occurrences
  BATCH_COLUMN = :id
  BATCH_SIZE = 250

  class BatchedBackgroundMigration < MigrationRecord
    self.table_name = "batched_background_migrations"
  end

  class BatchedBackgroundMigrationJob < MigrationRecord
    include ::EachBatch

    self.table_name = "batched_background_migration_jobs"

    belongs_to :batched_background_migration
  end

  def up
    return unless migration_id = BatchedBackgroundMigration.find_by(job_class_name: MIGRATION)&.id

    # rubocop:disable Style/SymbolProc
    BatchedBackgroundMigrationJob
      .where(batched_background_migration_id: migration_id)
      .each_batch(of: BATCH_SIZE) do |relation|
      relation.delete_all
    end
    # rubocop:enable Style/SymbolProc

    delete_batched_background_migration(MIGRATION,
                                        TABLE_NAME,
                                        BATCH_COLUMN,
                                        [])
  end

  def down
    # no-op
  end
end
