# frozen_string_literal: true

class RemoveCiPipelinesVulnerabilityFeedbackPipelineIdFk < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  def up
    return unless foreign_key_exists?(:vulnerability_feedback, :ci_pipelines, name: "fk_rails_20976e6fd9")

    with_lock_retries do
      execute('LOCK ci_pipelines, vulnerability_feedback IN ACCESS EXCLUSIVE MODE') if transaction_open?

      remove_foreign_key_if_exists(:vulnerability_feedback, :ci_pipelines, name: "fk_rails_20976e6fd9")
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_feedback, :ci_pipelines, name: "fk_rails_20976e6fd9", column: :pipeline_id, target_column: :id, on_delete: :nullify)
  end
end
