## 12.10.14 (2020-07-06)

### Security (1 change)

- Maven packages upload endpoint is now properly using the uploaded file set by middleware.


## 12.10.13 (2020-07-01)

### Security (2 changes)

- Fixed pypi package API XSS.
- Fix project authorizations for instance security dashboard.


## 12.10.12 (2020-06-24)

- No changes.

## 12.10.11 (2020-06-10)

### Security (1 change)

- Do not set fallback mirror user.


## 12.10.8 (2020-05-28)

### Fixed (1 change)

- Geo: Fix empty synchronisation status when nothing is synchronised. !30710


## 12.10.7 (2020-05-27)

### Security (3 changes)

- Change the mirror user along with pull mirror settings.
- Allow only users with a verified email to be member of a group when the group has restricted membership based on email domain.
- Do not auto-confirm email in Trial registration.


## 12.10.6 (2020-05-15)

- No changes.

## 12.10.5 (2020-05-13)

### Fixed (1 change)

- Remove check for user being an applicable code owner. !31809


## 12.10.4 (2020-05-05)

- No changes.

## 12.10.2 (2020-04-30)

### Security (3 changes)

- Fix rendering failure of Audit Event generated by Releases API.
- Ensure that NuGet package versions are SemVer compliant.
- Ensure that NuGet package versions are validated before updating the stored file path.


## 12.10.1 (2020-04-24)

### Changed (1 change)

- Move project deploy tokens section back to Repository settings. !29280


## 12.10.0 (2020-04-22)

### Fixed (6 changes, 1 of them is from the community)

- Split CI minutes resets into different workers. !29017
- Fix duplicated events on Value Stream Analytics stage form. !29030
- Fix missing autocomplete results in the ElasticSearch admin UI. !29043 (mbergeron)
- Support visual reviews on private and internal projects through PAT authentication. !29336
- Nuget search: fix the prerelease filtering. !29482
- Smartcard should be counted as 2fa. !29504

### Changed (6 changes)

- Default the :tasks_by_type_chart feature flag on. !28486
- Remove Add Metric button from custom dashboards. !29036
- Improve Geo Node save error messages. !29079
- Cosmetic changes for Epic Health Status. !29234
- Improve readability of Dependency List. !29593
- Restrict prompt to check user account settings only to Gitlab.com. !29672

### Added (15 changes)

- Add LDAP user filter to group link API. !26202
- Implement Shared Runner Minute Factors. !27792
- Updates the package registry list UI which also includes adding pipeline information. !28426
- Allow Admins to preview the payload for Seat Link requests. !28582
- Add deployment frequency to Project level Value Stream Analytics summary. !28772
- Add deployment frequency to Group Value Stream Analytics summary. !28776
- Provide milestone burnup chart data for scope committed graph. !28899
- Make Status Page MVC generally available. !28966
- License Compliance - Add `order_by` filter. !28970
- Add the selected compliance frameworks label to project home and listings. !29137
- Generate smaller versions of Design Management design files. !29215
- .com has a subscription expired banner. !29422
- Allow changing item parent in epic tree via GraphQL. !29567
- Add PyPI Packages Repository. !29702
- Enable requirements for projects and basic actions (CRUD) for them.

### Other (1 change)

- Add health status counts to usage data. !28964


## 12.9.10 (2020-06-10)

### Security (1 change)

- Do not set fallback mirror user.


## 12.9.8 (2020-05-27)

### Security (3 changes)

- Change the mirror user along with pull mirror settings.
- Allow only users with a verified email to be member of a group when the group has restricted membership based on email domain.
- Do not auto-confirm email in Trial registration.


## 12.9.6 (2020-05-05)

- No changes.

## 12.9.5 (2020-04-30)

### Security (3 changes)

- Fix rendering failure of Audit Event generated by Releases API.
- Ensure that NuGet package versions are SemVer compliant.
- Ensure that NuGet package versions are validated before updating the stored file path.


## 12.9.4 (2020-04-16)

- No changes.
### Fixed (2 changes)

- Update index_options to fix advanced search queries. !28712
- Geo: Fix repository verification on the primary. !28893

### Other (1 change)

- Use prefix search instead of ngrams for sha fields. !27597


## 12.9.3 (2020-04-14)

### Security (1 change)

- Fix filename bypass when uploading NuGet packages.


## 12.9.2 (2020-03-31)

### Fixed (4 changes)

- Fix direct access to individual design on deprecated issue route. !27650
- Fix error when viewing events from design notes on project activity page. !27840
- Allow Seat Link to be disabled through configuration or admin toggle. !28015
- Allow active_users param to be optional for SyncSeatLinkRequestWorker#perform. !28241

### Changed (1 change)

- Send active users for each day in seat link POST request. !27481


## 12.9.1 (2020-03-26)

### Security (1 change)

- Add NPM package versions SemVer validation.


## 12.9.0 (2020-03-22)

### Removed (1 change)

- Remove Security Dashboard button from project page. !24781

### Fixed (20 changes)

- Ensure User IDs are Removed When Moving to All Users Strategy. !25190
- Fix dismissed vulnerability comment updates. !25328
- Generate illustrations URLs in the backend. !25375
- Check user role for each of namespaces while deciding if it is using a paid seat in it. !25437
- Change MR approval popover to use hover trigger. !25494
- Change copy of Welcome screen. !25526
- Fix weight not showing in linked issues. !25718
- Scope name uniqueness of approval rules to type. !25875
- Pass correct Time object to Value Stream Management DataCollector. !25885
- API for Namespace members has correct boolean if user using paid seat. !25988
- Set the default SSL cert path environment variables when invoking indexer. !26036
- Add pagination to Instance Level Security Dashboard project selector. !26138
- Exclude creation event from audit changes. !26140
- Resolve Usage Ping timeouts on security_products_usage for large hosts. !26296
- Fix SCIM API not creating new users. !26514
- BulkIndexer change _routing -> routing to support ES 7. !26639
- Ensure design events are correctly visible. !26708
- Add support for async search within Epics dropdown. !26980
- Fix configuration issue for License Compliance. !27016
- Geo - Fix ambiguous reference column while loading migrated local files to clean up. !27252

### Changed (22 changes, 1 of them is from the community)

- Add auto_renew attribute to gitlab_subscriptions and expose via api. !24896 (jejacks0n)
- Remove admin user count from Users statistics. !25337
- Improve error messages in the Dependency List. !25369
- Do not automatically add approvers as participants of each merge request. !25546
- Improve loading UX in the License Management list. !25620
- Improve audit log & events header layout. !25821
- Adjust the MR approval rule to use a smaller modal. !25955
- Resolve Code review start time doesnt account for approvals. !25997
- Prevent 'Invite group' for groups outside a group-managed account group. !26081
- Improve language when MR Security Report is outdated. !26150
- Prevent projects from being shared outside a group with managed accounts. !26163
- Prevent projects from being shared outside a group with managed accounts for forked projects. !26186
- Extract time range information to be reused. !26431
- Restrict inviting outside group to a project forked from a group with enforced SSO. !26456
- Add severity badge to security reports. !26715
- Consider MR reassign as code review start. !26891
- Add application limits for Ci::PipelineSchedule. !27004
- Update license compliance policy classifications text in the UI. !27058
- Remove approval metric recalculation when approval was removed. !27071
- Move Value Stream Analytics to the group level. !27304
- Remove release tag filter from Issues Analytics. !208903
- Change dependency & license scan pipeline text message.

### Performance (4 changes)

- Optimize service desk issue counters query performance in usage data. !26445
- Preload database records in bulk indexing. !26754
- Geo: Make the LFS registry the SSOT to optimize query performance. !27154
- Remove feature flag elastic_bulk_incremental_updates. !27293

### Added (58 changes, 9 of them are from the community)

- Audit number of required approvals changes. !7531
- Add weight and progress information in Roadmap Epic bars. !18957
- Adds the ability to dismiss multiple vulnerabilities. !21480
- Add code quality tab to pipeline view. !21527
- Add milestones to roadmap. !22748
- Add Threat Monitoring page. !22911
- Add epic in filtered search. !22958
- Add deep links for cycle analytics. !23493
- Allow existing users to transfer their account to SAML Group managed accounts. !24329
- Use snowplow for user error reporting in trial. !24430
- Time period for usage activity by stage in usage data. !24431
- Adds sorting to group packages api. !24432
- Export Board Milestones in Group Export. !24606
- Add possibility to search for epics by partial iids using GraphQL. !24673
- Add restrict outer forks functionality for group SAML. !24698
- Release Jira connect feature. !24818
- Adds project_path sorting to group package API. !24833
- Add webhook limits for groups. !25129
- Default design images to 100% of viewport width. !25327
- Add npm_package_requests_forwarding to application settings. !25346
- Add bot count to Users statistics in Admin Area. !25355
- Adding CODEOWNER approval metrics for merge requests. !25386
- Separate 4 ee entities into own class file. !25400 (Rajendra Kadam)
- Improve zoom reset after resizing window in Design Management. !25406
- Introduce Project level issues analytics. !25417
- Add tooltip to guests count in Users Statistics. !25433
- Separate epic, epic_issue, linked epic ee entities into own class file. !25592 (Rajendra Kadam)
- Add API endpoints for Group Activity Analytics. !25606
- Add GraphQL mutation to set the epic of an issue. !25628
- Add merge request metrics first approved at timestamp. !25681
- Separate ee entities into own class file. !25709 (Rajendra Kadam)
- Embed cluster health metrics in GitLab-flavored Markdown. !25739
- Always show the Design Tab on Issues but indicate user if feature is not available. !25796
- Status page settings. !25820
- Audit user blocked via API. !25872
- Create a vulnerability-list component. !25927
- Audit project MR approval permission changes. !25959
- Add health status data to the epic GraphQL endpoint. !25989
- Display correct approval rules based on target branch in Edit MR form. !26053
- Activate triggering webhooks from a subgroup feature. !26070
- Separate vulnerabilities, feature flags, dependency entities into own class files. !26088 (Rajendra Kadam)
- Support drag-and-drop design uploads in Design Management. !26139
- Add distinct user count of secure stage items to usage ping. !26194
- Support drag-and-drop on existing designs in Design Management. !26446
- Add worker to sync paid seats info daily in the background. !26467
- Separate project alias, build info, package entities into own class files. !26493 (Rajendra Kadam)
- Support async loading & search of projects within Epics Tree. !26661
- Add code review reassign metric structure. !26664
- Separate npm, subs and geo entities into own class file. !26674 (Rajendra Kadam)
- Separate geo_node and license entities into own class file. !26685 (Rajendra Kadam)
- Separate merge request approval entities into own class files. !26860 (Rajendra Kadam)
- Include snippet description as part of snippet title search (advanced search, Elasticsearch reindexing required). !26870
- Add Roadmap GraphQL and unfiltered epic aggregates. !26919
- Add NPM package requests forwarding to npmjs.org. !26932
- Separate approval entities into own class files. !27336 (Rajendra Kadam)
- View description changes history of issues, epics and merge requests. !27445
- Enable license compliance policies tab for on prem installs.
- Add a bulk processor for ES incremental updates.

### Other (5 changes, 1 of them is from the community)

- Refactor WeightSelect to use gitlab-ui dropdown. !20770
- Update to new severity badge design. !25489
- Rename close_{at,by} to dismissed_{at,by} in Vulnerabilities. !25609 (Michał Zając)
- Style MR approval popover link to be consistent text size. !25657
- Allow users to be marked as service users. !202680


## 12.8.10 (2020-04-30)

### Security (3 changes)

- Fix rendering failure of Audit Event generated by Releases API.
- Ensure that NuGet package versions are SemVer compliant.
- Ensure that NuGet package versions are validated before updating the stored file path.


## 12.8.9 (2020-04-14)

### Security (1 change)

- Fix filename bypass when uploading NuGet packages.


## 12.8.7 (2020-03-16)

### Fixed (1 change)

- Allow multipart uploads for packages. !26387


## 12.8.6 (2020-03-11)

- No changes.

## 12.8.5

- No changes.

## 12.8.4

- No changes.

## 12.8.3

- No changes.

## 12.8.2

### Security (5 changes)

- Don't show Contribution Analytics to users who are not group members.
- Update epic tree when group is transferred.
- Fix Service Side Request Forgery in JenkinsDeprecatedService.
- Enforce vulnerability feedback pipeline is in the same project.
- Enforce existing vulnerability feedback pipeline is in the same project.


## 12.8.1

### Performance (1 change)

- Geo - Fix query to retrieve Job Artifacts when selective sync is disabled. !25388


## 12.8.0

### Removed (1 change)

- Remove confidence labels from security report. !24033

### Fixed (33 changes, 1 of them is from the community)

- Fix UI on Project Audit Events when the feature not available. !16032 (Takuya Noguchi)
- Group SSO handles locked users gracefully instead of showing 500 error. !20329
- Fix incorrect security status counts. !22650
- Fix include subgroups in security status. !22653
- Make sure type is set properly in Elasticsearch query when doing global search. !22821
- Include users from all sub-projects and shared groups when counting billing seats currently in use. !22967
- Fix vulnerability finding list endpoint query timeout on instance security dashboard. !23232
- Add app validation for any-approver rule uniqueness. !23241
- Fix 500 error in global search for blob, wiki_blob and commit search. !23326
- Fix group hook triggering from subgroup project. !23333
- Change conditions when user uses license seat. !23522
- Accept group path as ID when fetching notes from API. !23535
- Fixes a bug that prevented auto-remediation on the pipeline security dashboard. !23677
- Fix nav link in security submenu. !23775
- Order epic related issues by relative_position. !23776
- Correctly display the number of approvals for a merge request. !23827
- Fix orphan issues that were promoted to epics. !23916
- Fix rendering of design management references. !24001
- Fix 500 error when browsing the roadmap page for a group the user is not authorized to view. !24002
- Use project slug instead of name for Error Tracking Settings Display. !24176
- Display error message in MR License Report if it fails to load. !24201
- Fix display logic of Securty Report MR widget. !24204
- Set SSL certificates path env when calling ES indexer. !24213
- Allow submit to event to trigger a new search. !24262
- Fix npm package uploads when bundleDependencies is set to false. !24355
- Resolve 500 error after Web IDE terminal use. !24443
- Added commas to current active user count when appropriate. !24549
- Hide duplicate company/individual question on trial selection. !24567
- Update invalid SPDX identifiers in software licenses table. !24829
- Cleanup deprecated package dependency links. !24868
- Fix to display a link to the logs in both embed and dashboard. !25288
- Disable self-approval at the Instance level - Fix approvals filtering. !25385
- Allow user to close sidebar while editing boardlist and save wip limit.

### Changed (13 changes)

- Display generic error in codeclimate MR widget when base_path is null. !21666
- Adjust skip trial copy in trial sign up flow for SaaS users who are logged in. !22923
- Use export icon instead of download for the export button in the Dependencies List. !23094
- Apply darker color to column headers and scan names in secure features configuration. !23104
- Redacts quick actions used by support bot. !23353
- Remove Code Review Analytics feature flag. !23418
- Delete description change history - Frontend. !23568
- Support moving the design repository of a project when the project is transferred to a new namespace. !23573
- Display proper error messages on vulnerabilities fetch failure. !23812
- Add date range validation for Cycle Analytics at the backend side. !24254
- Exclude GitLab generated bot users from using a license seat. !24275
- Changes the standalone vulnerabilty endpoint. !24777
- Move Productivity Analytics page to the group level. !25329

### Performance (1 change)

- Geo - Fix query to retrieve Job Artifacts when selective sync is disabled. !25388

### Added (42 changes, 1 of them is from the community)

- Create DesignAtVersion model, exposing it with GraphQL. !15260
- Add Group-level compliance dashboard MVC. !20844
- Adds sorting to package api. !20963
- Allow to soft delete issuables description history. !21439
- Display warning flash if design upload is skipped. !21615
- Ask if a user is trying GitLab for his company or for his individual usage. !22280
- Support design tab link references for issues. !22330
- Allow using custom user name for service desk emails. !22478
- Raise exception if any namespaces runner minutes were not reset. !22636
- Adds vulnerability management state dropdown. !22823
- Add additional license information to admin dashboard. !22866
- Add sort by date to audit logs and events. !22887
- Add Group WebHooks API. !22994 (Rajendra Kadam)
- Add API route to confirm a vulnerability. !23099
- Creates the standalone vulnerability list page. !23438
- Show license badge for Gitlab.com member overview. !23521
- Create audit log when username changes. !23576
- Resolve Disable self-approval at the Instance level. !23731
- Add time picker to logs page. !23837
- Introduce Credentials Inventory for Groups that enforce Group Managed Accounts. !23944
- Add API for protected environments. !23964
- Prompt users to check their account settings. !23994
- Allow to pick a subgroup to hold the Insights config. !24053
- Add health_status column to issues and epics tables. !24202
- Add a link in dashboard to allow users to go to the logs page. !24240
- Record audit event when user is deleted. !24257
- Time Series chart filtered time range (datazoom) becomes reflected in the View logs link. !24343
- Scope merge request approval rules to protected branches using API search. !24344
- Add application limit for ES indexed field length. !24345
- Add affected projects feature to instance security dashboard. !24644
- Add trial field to namespaces API. !24666
- Make elasticsearch bulk parameters configurable. !24688
- Add feature filter for users. !24765
- Design view: moveable `new comment` pin. !24769
- Record audit event when user is added. !24855
- Add group identification headers to epic emails. !24878
- Record audit event when user is blocked. !24930
- Moveable design note pins. !24934
- Add NuGet Repository. !25157
- Add single-level Epics to EE Premium. !25184
- Show View logs link in embed metrics. !25217
- Add usage ping counter for events. !199874

### Other (1 change)

- Prepare DB structure for GMA forking changes. !22002


## 12.7.9 (2020-04-14)

### Security (1 change)

- Fix filename bypass when uploading NuGet packages.


## 12.7.5

### Fixed (1 change)

- Fix DB connection pool size for Geo database. !24021


## 12.7.3

- No changes.

## 12.7.1

### Fixed (1 change)

- Fix create/delete API calls for approval rules. !23107


## 12.7.0

### Removed (2 changes)

- Remove `project_ci_cd_settings.merge_trains_enabled` column. !19701
- Remove old pipeline security report view in favor of the Security Dashboard. !22152

### Fixed (20 changes, 1 of them is from the community)

- Add error flashes to Design view. !20889
- Pending (unsubmitted) review comments with multiple lines now display whitespace before being submitted. !21435
- Fixed GitLab admin not seeing merge requests in Jira Development Panel Integration. !21467
- fix CSS shadowbox on focus. !21785 (allenlai18)
- Fix GraphQL access to groups with SAML SSO Enforcement. !21922
- Remove spinner when approval require input is changed. !22186
- Add billing plans box to profiles. !22270
- Use full reference in Epic Issue GraphQL query. !22292
- Support new Azure SCIM pre-setup check. !22348
- Show expiry details in Audit events when changing acesss levels. !22412
- Fix PruneOrphanedGeoEvents to pass in demodulized name to BackgroundMigrationWorker. !22451
- Update widget on click dropdown item when creating epic from epic. !22511
- Ensure When userWithId Is Picked User IDs are Sent. !22528
- Fix initial sorting of non-persisted Cycle Analytics stages. !22541
- The Active tab on the Admin Users page should include bots. !22543
- Fix reply emails with attachments for epics. !22547
- Fix child epics depth validation. !22729
- Users without a license do not use a seat. !23146
- Fix access to horizontal scrollbar when zooming in on a design.
- fix positioning of design overlay pins when viewing design.

### Changed (13 changes)

- Rename "Production" stage in Cycle Analytics to "Total". !21450
- Update copy for start a free gold trial screen. !21820
- Show Geo node's name in admin page. !21876
- Improve validation message when a design extension is unsupported. !21888
- Prevent spiders indexing contribution analytics. !21896
- Replace depricatedModal (Geo) with GlModal. !22125
- Allow namespaces in a trial to upgrade to any plan. !22273
- DAST vendored template pins DAST to latest major version. !22371
- Rename productivity analytics date parameters. !22377
- Rename Contribution Analytics endpoint URL. !22877
- Move 'Allow admins to disable users ability to change profile name' feature to Premium tier. !23034
- Change security dashboard's filters bar background. !23094
- Add First & last name on the trial form. !33742

### Performance (3 changes)

- Cache vulnerability summary per project/group. !21373
- Fix N+1 SQL queries with protected environments. !22101
- Optimize Group#for_epics scope. !22375

### Added (26 changes)

- GitLab Pages - Storage size Limitations by Project or Group. !17725
- Add Instance Security Dashboard feature. !18008
- Add NPM dist-tag support. !20636
- Track resource weight changes. !21515
- Add support for custom email templates for service desk. !21745
- members list to group sso page. !21852
- Alow to filter by saml identity linked for group members API. !21931
- Added submit_review quick action. !22061
- Adds project_id and project_path to package group api. !22089
- Add trial_ends_on to Namespaces API. !22121
- Uniquifies path slug creation from trial new group name. !22147
- Capture Release actions in the audit log page. !22167
- Add ability to cancel a design discussion. !22241
- Enable License compliance feature for all instances. !22250
- Add support for license_scanning artifact report. !22277
- Add trial counters to usage ping. !22279
- Support gl-license-scanning-report.json file. !22312
- Includes _link object in packages list api. !22503
- Geo - Replicate project designs repositories. !22544
- Add information about epic to Issue list csv export. !22662
- Scope approval rules by protected branches via API. !22673
- Prevent a child pipeline to create further child pipelines. !22675
- Adds pipeline object to package API. !22854
- Add zooming functionality to designs in Design view. !22863
- Introduce Code Review Analytics page. !23031
- Add support for work in progress limits - Max issue count only.

### Other (3 changes, 1 of them is from the community)

- Generate appropriate Vue key for licenses list table. !21566 (allenlai18)
- Limit size of search query for non ES searches. !22208
- Remove "creations" in gitlab_subscription_histories on gitlab.com. !22278


## 12.6.7

- No changes.

## 12.6.6

- No changes.

## 12.6.5

- No changes.

## 12.6.4

- No changes.

## 12.6.2

### Security (2 changes)

- Don't publish drafts if user can't create notes.
- Remove protected tag access when group is removed.


## 12.6.1

- No changes.

## 12.6.0

### Fixed (32 changes, 5 of them are from the community)

- Exclude forks from Group Security Dashboard filter. !14667
- Clarify why Service Desk feature is unavailable. !19244
- Bump code quality version in template to 0.85.5. !19354
- Nullify user roles that have been accidentaly set to a value of 0. !19569
- Display CI Minutes warning only if minutes left is still below last level. !19751
- Add a unique constraint to `software_licenses.name` column. !19840
- Link user accounts to new Smartcards identities on login. !20059
- Allow valid namespace paths with dots for api PUT. !20079
- Map software license names from the v1 license scan report to an equivalent SPDX identifer. !20195
- Prefer sending external pull request pipeline statuses over general statuses to GitHub. !20364
- Abort rendering of security reports that aren't enabled. !20381
- Fix Infinite Scrolling on Environments Dashboard Project Selector. !20408
- Link user accounts to new Smartcards certificate ldap identities on login. !20470
- Handle design repositories when moving a project to a new storage. !20509
- Resolve Version dropdown goes wrong if versions are not monotonic. !20515 (Tom Quirk)
- Turn auto_complete_issues on by default. !20525
- Handle design repositories when moving existing projects to Hashed Storage. !20540
- Fix dependency metadata on the NPM registry responses. !20549
- Fix the hiding of undismissed vulnerabilities. !20599
- Fix check for existing ES limited indexing IDs. !20866
- Show actions area for fixed vulnerabilities in merge requests. !20867
- Fix typo in Kubernetes GKE setup error message. !21091
- Include projects in subgroups in group boards relative position. !21189
- Fix inability to add comments to a discussion in Design Management. !21229
- Fix Infinity % / Infinity % on Stacked Progress Bar. !21437
- Fix sort icon direction when sorting by weight. !21447 (Jan Beckmann)
- Auto-focus title text box when creating new epics. !21516 (Jan Beckmann)
- Fix analytics icon alignment. !21555
- Invalid trial form to remember user & country. !21840
- Fix styling on contribution analytics dashboard. !207012 (briankabiro)
- Add correct link to milestone in groups for issuables list after refactor.
- Show the proper message when adding a duplicate issue to an epic. (20175)

### Changed (13 changes, 1 of them is from the community)

- Make "Learn more about" links for security scanning popovers on merge request page open in new tab. !13333 (Daniel Tian)
- Redirect Admin > Settings > Geo to Admin > Geo > Settings. !19833
- Expose epic_id parameter in issues API. !19953
- Allow to login with Smartcard certificates using SAN extensions that only defines one global email identity. !20052
- Update SAST.gitlab-ci.yml - Add kubesec analyzer. !20129
- Update start trial CTA in top right banner to only appear if all namespaces are free. !20177
- Update billing page trial CTAs. !20383
- Rename software_license_policies.approval_status to software_license_policies.classification. !20414
- Add ability to edit Group Hooks. !20898
- Improve the performance of group templates finder. !20947
- Hide elasticsearch namespaces and projects when too many in rollout. !21225
- Update Explore Geo Page. !21448
- Renamed Conversational Development Index feature to DevOps Score.

### Performance (1 change)

- Do not trigger count query for pagination without count. !21232

### Added (24 changes, 2 of them are from the community)

- Add new approval rule type which allows anyone to approve. !15378
- Add Personal access token expiry policy. !17344
- Expose time logs for group issues via the GraphQL API. !18689
- Add application settings needed for soft-deletion. !18790
- Add link to new epic for promoted issues. !18839 (Jan Beckmann)
- Use issue templates on service desk(backend). !19515
- Log history for gitlab_subscriptions table. !19694
- Resolve Show plan of root group on subgroup details page. !20218
- Adjust group members API to include group SAML info. !20357
- Add user ability to append template to incoming service desk issues. !20476
- Add audit event when member access is removed due to expiration. !20529
- Update CI templates to use sitespeed 11.2.0. !20561
- Added migration for issue link types. !20617
- Add security configuration navigation item. !20711
- Create a new database composite index to support cross-project artifacts downloads. !20721
- Add deployment API updated_at filters. !20731
- Show loading spinner in design card while design is uploading. !20814
- Add most affected projects to group security dashboard. !20892
- Introduce Credentials Inventory. !20912
- Add GraphQL mutation for changing weight of an issue. !21331
- Cache vulnerability findings history endpoint for security dashboards. !21349
- Added Marginalia feature which can generate PostgreSQL query comments to Gitlab. !21364 (BalaKumar)
- Add API for states by country. !21417
- Improved trials sign up for gitlab.com. !21650

### Other (8 changes, 2 of them are from the community)

- Store and look up design management version authorship from database. !17322
- Remove redundant ManagedLicenses controller. !20131 (briankabiro)
- Updated board_service.js to use boardStore directly. !20141 (nuwe1)
- Delete any stale deploy access levels by group. !20689
- Add project webhooks limits on GitLab.com. !20730
- Remove the design_management_flag feature flag from the codebase. The feature flag toggles the Design Management feature, and has been enabled by default since 12.2. !20883
- Remove operations_feature_flags_clients.token column. !21016
- Update the alerts used in the Dependency List to follow GitLab design guidelines. !21760


## 12.5.8

- No changes.

## 12.5.5

- No changes.

## 12.5.4

### Security (1 change)

- Fix stale Elasticsearch permissions when moving group from public group to private parent group.


## 12.5.3

### Performance (1 change)

- Geo - Improve query performance to determine job artifacts to sync when selective sync is enabled. !19583

### Other (1 change)

- Geo - Does not schedule duplicated jobs while backfilling uploads, LFS objects and job artifacts. !20324


## 12.5.1

### Security (6 changes)

- Protect Jira integration endpoints from guest users.
- Fix private comment Elasticsearch leak on project search scope.
- Filter snippet search results by feature visibility.
- Hide AWS secret on Admin Integration page.
- Fail pull mirror when mirror user is blocked.
- Prevent IDOR when adding users to protected environments.


## 12.5.0

### Security (5 changes)

- Fixes a Open Redirect issue in `InternalRedirect`.
- Filter out packages the user does'nt have permission to see at group level.
- Do not show private cross references in epic notes.
- Redact search results based on Ability.allowed?.
- Do not index system notes for issue update.

### Removed (2 changes, 1 of them is from the community)

- Remove the Geo Clone Modal. !18897 (Zack Cuddy)
- Remove Pendo Snippet. !19400

### Fixed (17 changes)

- Fix notification button size in notification settings. !16672
- Don't store full blob path in ES filename field. !18470
- Add messages to warn and stop users when attempting to change the path of projects with NPM packages. !18515
- Pass pipeline variables when expanding Bridge downstream variables. !18875
- Fix equality operator for Prometheus alerts. !18919
- Fix rake task to rollback Geo migrations. !18975
- Default current user to mirror user when creating pipelines for GitHub pull requests. !19072
- Fix overlapping `Skip Trial` block. !19218
- Fix Dependency List is empty if last pipeline is retried. !19241
- SCIM pagination startIndex handles string input. !19331
- Display packages with multiple licenses. !19333
- Expose commit sha on Vulnerabilities::Occurrence. !19668
- Fix admin welcome image not found. !19676
- Revert ES support for public/internal project snippets. !19715
- Updated View documentation link on cluster page. !19780
- Enable pod logs nav menu only for maintainers in projects with k8s environments. !19927
- Hide labels from issue board cards. !20072

### Changed (13 changes)

- Inherit children epics start and due dates. !14366
- Update the frontend diffing code to support v2 license scan reports. !18105
- Implement pod logs page using Vue. !18567
- Move DAST reports logic for the Merge Request widget to the backend. !18660
- Add created_before/after filter to audit events. !19035
- Get rid of unnecessary duplication of alert’s title from Alert Details. !19214
- Hashed storage is now a requirement for Design Management. !19259
- Expose epic in issues API. !19300
- SCIM GET /Users supports requests without a filter. !19421
- Enable Cycle Analytics Feature by default. !19484
- Enforce a max size accepted for sentry issues list. !19649
- Limit input size for Prometheus alert JSON payload. !19940
- Adds in a URL field for DAST reports modal data. !20162

### Performance (2 changes)

- Fix new project page load performance. !18180
- Geo - Improve query performance to determine LFS objects to sync when selective sync is enabled. !19051

### Added (17 changes, 1 of them is from the community)

- Add filter for dismissed vulnerabilities on security dashboards. !16692
- Data API endpoint for tasks by type chart within the analytics workspace. !17944
- Hide labels from issue board cards. !18533
- Skip Onboarding feedback when tracking is disabled. !18671
- API endpoint to list the packages of a group. !18871
- Allow to create epics with GraphQL. !19030
- CI_JOB_TOKEN can be accepted with 'Bearer ' prefix to allow for NPM registry usage. !19059
- Add issue IID to a title of generic alerts with a default title. !19086
- Update sidebar to differentiate between groups, subgroups, and projects. !19158
- SCIM can be used to manage group membership. !19329
- Expose number of sub-epics and epic issues in GraphQL API. !19450
- Add logs menu item to the sidebar. !19471
- Add public API for Feature Flags. !19547
- Ignore project_ci_cd_settings.merge_trains_enabled column. !19695
- Add a usage ping metric for number of activated Alert Services. !19765
- New discussions on designs will generate a system note on the issue. !19990
- Expose SHA of squashed commit via API when fast-forward merge is enabled. (minghuan lei)

### Other (6 changes, 1 of them is from the community)

- Migrated contributors charts to echarts. !16677
- Added autogenerated Markdown support for Vulnerability title and description. !18283
- Rename user_id to author_id in design_management_versions table. !18506
- Revert notification for updated privacy policy. !18900
- Remove plaintext tokens for feature flags clients. !18923
- Remove IIFEs from jira_connect.js file. !19248 (nuwe1)


## 12.4.8

- No changes.

## 12.4.5

- No changes.

## 12.4.3

### Fixed (2 changes)

- Fix admin welcome image not found. !19676
- Revert ES support for public/internal project snippets. !19715


## 12.4.2

### Fixed (1 change)

- Fix feature flag check for productivity analytics. !19025


## 12.4.1

### Security (6 changes)

- Do not display project labels that are not visible for user accessing group labels.
- Do not index system notes for issue update.
- Redact search results based on Ability.allowed?.
- Do not show private cross references in epic notes.
- Filter out packages the user does'nt have permission to see at group level.
- Fixes a Open Redirect issue in `InternalRedirect`.


## 12.4.0

### Security (2 changes)

- Prevent IDOR when adding groups to protected environments.
- Hide approvers if a rule has any hidden groups.

### Removed (1 change)

- Remove db_load_balancing_index gauge metric. !17561

### Fixed (26 changes, 1 of them is from the community)

- Admin settings errors now shown in the correct panel. !14374
- Add missing error handling for epic quick actions. !15648
- Fix project exports clobbering concurrent export paths. !16280
- Fixes scroll handle icon in time series. !16354
- Remove hardcoded Medium confidence for Container Scanning vulnerabilities. !16395
- Fixed renaming changed files. !16539
- Fix project-defined metrics dashboards not rendering. !16589
- Remove duplication of Licenses in Dependency List page. !16946
- Backfill SPDX identifiers in software_licenses table. !17004
- Monitor charts: Validate form for creating an alert before submitting. !17109
- Hide Push rules link when you dont have a license installed. !17530
- Operations Dashboard: fix minimum query message. !17574
- Fix page layout for sidebar on designs view. !17579
- Display error for invalid insights config. !17589
- Display appropriate approval status icon next to license. !17613
- Fix deduplication of WASC vulnerabilities in the Security dashboard. !17778
- Fix burndown negative count edge case. !18053
- Change design management empty state button style. !18060 (George Tsiolis)
- Decouple dependency list parser from v1.0 license scanning report. !18103
- Respect Group SSO Enforcement on projects where the user is an owner. !18154
- Scoped labels do not remove old label in board sidebar. !18313
- Restrict number of users input to positive numbers. !18381
- Fix undefined method log_geo_deleted_event for MergeRequestDiff. !18405
- Add default empty values to prevent parser errors from approving the Vulnerability-Check rule. !18423
- Fix time tracking info when the sidebar is collapsed.
- Fix Discussion tab counter on Issues.

### Changed (18 changes, 1 of them is from the community)

- Style burndown charts with gitlab-ui. !15463
- Add epic_iid parameter to issues API. !15640
- Use a single badge to show number of active alerts on metrics dashboards. !15789
- Allow files with .svg extensions to be uploaded as designs for Design Management. !16160
- Implement dismissal behaviour when dismissed vulnerabilities are hidden. !16207
- Remove environment_metrics_show_multiple_dashboards feature flag. !16640
- Make name an optional parameter of releases. !16647
- Expose epics closed_at on API. !17156
- Add static_context API param when editing GitHub project service. !17397
- Support variable expansion in branch property of bridge jobs. !17430
- Add environment dropdown to pod logs screen. !17532
- Parse v2 license scanning reports. !17646
- Remove broken HTML5 routing behaviour from Pipeline Security Dashboard. !17767
- Change Prometheus Alert details list from bulleted to description list. !18116 (Vitali Tatarintev)
- Check for software license violations using SPDX identifiers. !18300
- Move 'Advanced search' message to search page title. !18349
- Add alert message for feature 'require approval from code owners' being moved. !18715
- Enable Productivity Analytics feature by default. !18754

### Performance (1 change)

- Reduce excessive GC on pull mirrors. !17931

### Added (35 changes)

- Allow Design Management files and data to be included in the project exporter/importer. !14702
- Create system notes for design events. !14791
- Paginate SCIM responses using count and startIndex. !14892
- Front-End UI for design deletion. !15034
- Add max issue count to lists. !15116
- Sign in / sign up step for trial. !15289
- Add notification for updated privacy policy. !15435
- Show Billing Plan as Cards in profile and groups. !15437
- Add Audit Event API. !15698
- Add configurable Code Owner approvals for protected branches. !15862
- Add Alerts Service to Projects. !16117
- Add Conan check_credentials API endpoint. !16215
- Initial endpoint for exposing Cycle Analytics stages for the new frontend. !16240
- Add ability to multi select issue board cards. !16317
- Add License-Check approval UI. !16371
- Add links to associated releases on Tags page. !16479
- Frontend implementation for improved trial sign-up experience for GitLab.com (SaaS) users. !16732
- Return Todos for Designs via the REST API. !16885
- Set active insights dashboard tab from hash fragment. !16904
- Extend group IP restriction to Git activity. !16980
- Inactivate pipeline retries for Merge Trains. !17065
- Expose time when the build was generated. !17113
- Add new table for recording commit counts per file. !17277
- Add vendored template for Browser Performance Testing. !17319
- Link Gitlab managed Prometheus alerts and issues. !17477
- Disable insights tab navigation whilst current page loads. !17678
- Drop all merge requests from merge trains when the project-level setting is disabled. !17774
- Implement DAST for default branches. !17789
- Add rack attack settings for prometheus and generic alert endpoint. !17859
- Add Licenses list backend usage ping. !17925
- Associate self-managed Prometheus Alerts and Issues. !18046
- Operator can see all projects using an instance level cluster. !18173
- Expose subscribed attribute for Epics in GraphQL. !18607
- Expose epic participants on GraphQL. !18691
- Adds a generic alert integration which can accept alerts from any source via a generic webhook receiver.

### Other (4 changes)

- Productivity analytics: Add scatterplot. !15569
- Updated sidebar navigation icons to be horizontally centered when bar is condensed. !16820
- Pin major version of SAST analyzers. !17110
- Docs for protected branch code owner approval API. !17132


## 12.3.9

### Security (1 change)

- Fix stale Elasticsearch permissions when moving group from public group to private parent group.


## 12.3.7

### Security (6 changes)

- Protect Jira integration endpoints from guest users.
- Fix private comment Elasticsearch leak on project search scope.
- Filter snippet search results by feature visibility.
- Hide AWS secret on Admin Integration page.
- Fail pull mirror when mirror user is blocked.
- Prevent IDOR when adding users to protected environments.


## 12.3.4

### Fixed (2 changes)

- Fix replies to service desk emails for projects with issue access as Only Project Members. !17401
- Geo: LFS not being synced. !17633


## 12.3.2

### Security (2 changes)

- Hide approvers if a rule has any hidden groups.
- Prevent IDOR when adding groups to protected environments.


## 12.3.1

- No changes.

## 12.3.0

### Security (3 changes)

- Limit number of jobs in running pipelines for the past hour on per plan basis. !1182
- Filter out old system notes for epics in notes api endpoint response.
- Do not allow creation of projects from group templates if project is not descendant of that group.

### Removed (1 change)

- Remove Ruby Elasticsearch indexer. !15641

### Fixed (53 changes, 5 of them are from the community)

- LDAP group sync: check parent group membership and improve performance. !13435 (Alex Lossent)
- Added a migration which fixes discussions for existing promoted epics. !14708
- Fix Docker Registry access when Group SAML session enforcement is active. !14843
- Fix missing borders between settings items. !14877
- SCIM uses fallbacks when name.formatted not present. !14878
- Fix visibility of link to dependency-list in project sidebar based on permissions. !15066
- Hide info for unlicensed projects on Ops Dashboard. !15099
- Fix focus-visibility of vulnerability-actions within security dashboard. !15115
- Resolve Design viewer does not respect version. !15119
- Fix bug to display alert menu correctly in dashboards. !15261
- Allow developer role to access group-level templates when creating a new project. !15364
- Maintain related issues after moving issue. !15391
- Fix the documentation link on the empty Dependency List page. !15402
- Fix broken docs link on security dashboard. !15404
- Change epics count in sidebar to only count open epics. !15459
- Include ancestor group labels in autocomplete for epics. !15460
- Enable target users across all feature flag environment scopes. !15500
- Change payload for comparing security reports in MR widget. !15531
- Add space between CI usage warning messages. !15563 (briankabiro)
- Make sure groups with templates finder returns subgroups. !15631
- Properly delete files when a package is removed. !15634
- Fix x-axis burndown chart offset by timezone. !15690
- Resolve SRV records for DB load balancing. !15691
- Ensure all CI minutes used are reset for all namespaces and relative projects. !15744
- Show proper error in SCIM create user endpoint. !15756
- Update permissions on Dependency List page. !15771
- Allow ancestor group milestones in issue board scope. !15858
- Show weight on new board issue. !16028 (Lee Tickett)
- Do not show 'automatically removed' suffix for manually removed labels. !16079
- Link to the embedded doc in the Geo callout about hashed storage. !16114
- Fix LFS authentication URL in EE. !16146
- Prevent project's approval rules having same name. !16216
- Fix create issue for container scanning from security dashboard. !16226
- Add current_user to security report comparison services. !16252
- Fix setting of weight of a new issue in board list. !16299
- Update ExternalPullRequest on :synchronize action to ensure source_sha is updated locally. !16318
- Fix wrong tier error message for Operations dashboard. !16319
- Perform case insensitive diff on license names. !16335
- Moves Buy additional minutes button to the pipelines tab. !16443
- Update GitHub Importer Personal Access Token field description for CI/CD projects only to reflect latest OAuth changes. !16453
- Use Pull Request number instead of internal Pull Request ID. !16504
- Fix service desk emails not creating issues intermittently. !16577
- Reinitialize metrics files on webserver master process start. !16623
- Fix the group's epic page. The Paste issue link placeholder shown as 'undefinedundefinedundefined' in Chinese environment. And the error message showed nothing. !16628 (wdmcheng)
- Fix issue redirects going to /issues/:id/designs. !16638
- Eliminate analytics feature flag requirement for /analytics routes. !16663
- Match environment names case insensitively for feature flag spec search. !16691
- Fix merge request redirects going to /commits page. !16705
- Align text color for edited with issue/mr. !16721
- Added Packages top item to the group level packages fly out navigation menu. !16791
- Restores data for assignee changes in merge request webhooks. !16812 (Jesse Hall @jessehall3)
- Fix alignment of comments count in issue and MR lists. !16829
- Wait until pipeline is completed before checking for software license violations. !16853

### Changed (27 changes, 1 of them is from the community)

-  Geo: Refactor data-sources to allow for replication of content in Object Storage. !13997
- Improve UX multi assignees in MR. !14851
- Add ability to block API pushes to protected branches when contents match CODEOWNERS rule. !14900
- Add browser notications to add/edit/delete vulnability dismissal reasons. !15015
- Geo: Add orphaned project registry cleaner. !15021
- Update Security Dashboard for improved usability. !15050
- Present SAST report comparison logic to backend. !15114
- Ensure design notifications are sent. !15250
- Apply the group setting "Restrict access by IP address" to API requests. !15282
- Hide boards-switcher on group boards. !15293 (briankabiro)
- Group Security Dashboard shows projects with security reports only. !15334
- Use GlEmptyState component for design management empty state. !15374
- DB Load Balancing: Log Prometheus current number of hosts and current index. !15440
- Clarify SSO enforcement setting behaviour. !15533
- DB Load Balancing: Support SRV lookups. !15558
- Add status checking behaviors to pipeline triggers. !15580
- Only show Service Desk email address to project members. !15676
- Use static status check names on GitHub integrations. !15737
- Display the Security Dashboard in the Security tab of the pipeline view. !15824
- Remove primary button from feature flags empty state and update text. !15841
- Extend License Compliance entity for Pipelines and MR view. !15957
- Improve DB load balancing log to log host offline due to replication lag. !15995
- Eliminating `analytics` feature flag and introduce separate feature flags for Analytics features. !16102
- Add asterisk to name field in new feature flag form. !16248
- Update Container Scanning job template, use klar image. !16342
- Improve projects list page UI. !16656
- Add user feedback to exit routine of onboarding tour.

### Performance (2 changes)

- Send only necessary fields on mr-widget auto-refresh. !15495
- Two step Routable lookup. !16621

### Added (46 changes, 1 of them is from the community)

- Public project-level approval rule API. !13895
- Support reordering issues and epics using Drag&Drop. !14565
- Add deletion support for designs. !14656
- Add Epics select dropdown to Issue sidebar. !14763
- Edit delete vuln dismissal message. !14770
- add Productivity Analytics page with basic charts. !14772
- Add License information to the Dependency List based on current license rules. !14905
- Adds an api to generate suggestions for username. !15048
- Add Upgrade button to the User Billing page. !15075
- Enable "only/except: external_pull_request" with GitHub integration when a pull request is open for the given ref. !15082
- Allow to filter epics by timeframe or state using GraphQL. !15110
- Support restricting group access by multiple IP subnets. !15142
- Merge License info to Dependency List report. !15157
- Add Licenses info into Dependencies response. !15160
- Add 'License-Check' approval rule to enforce license compliance policy. !15196
- Added a toggle to show/hide dismissed vulnerabilities in the security dashboard. !15333
- Add audit event for archiving & unarchiving projects. !15362
- Pressing the Escape key now closes designs in Design Management. !15379
- Expose a count of Notes for a Design in a new notes_count property of DesignType in GraphQL. !15433
- Implement public MR-level approval rules API. !15441
- Cancel redundant merge train pipelines. !15450
- Add vulnerabilities to Dependencies API. !15485
- Expose a new events property of DesignType in GraphQL that represents the change that happened to a Design within a given version. !15561
- Add new layout for trial. !15630
- Track repository pushes as audit events. !15667
- Create Metadata/Tags table. !15770
- Allow SmartCard authentication to use SAN extensions. !15773
- Maximum Users metric in Admin Dashboard includes current active user count. !15810
- Public MR-level approval state API endpoint. !15859
- Add secondary lag message on Git push over HTTP. !15901
- Expose epic_iid in issues API. !15998
- Refresh license approval check when a license is blacklisted. !16070
- Disable editing of the 'License-Check' approval rule name. !16149
- Implement Cluster Environments polling. !16316
- Support creating project from template via API. !16352
- Add link to additional shared minutes from pipeline quote overview. !16389
- Add audit events for protected branches. !16399
- Geo: Exit LogCursor if it has been failing for too long. !16408
- Implement design comment counts and current-version status icon indicator. !16416
- Track page view counts for Cycle Analytics and Productivity Analytics features. !16431
- Update release blocks to support association of milestones. !16562
- Set default whitespace diff behaviour. !16570 (Lee Tickett)
- Implement `/zoom` and `/remove_zoom` quick actions. !16609
- Add Snowplow click tracking for issue sidebar. !16833
- Upgrade pages to 1.9.0.
- Adds total usage information to the usage quotas page.

### Other (27 changes, 8 of them are from the community)

- Update Pipelines Minutes expiry banner to Alert Component. !14786
- Add internal API for group cluster environments. !15096
- Rename approval rule. !15140
- Productivity Analytics: Add error handling for reporting on groups which have no plan. !15291
- Convert Issue Analytics chart into ECharts. !15389
- Display group's full name when creating a project from custom group-level project templates. !15392
- Only in ee available selection entries in user settings adapted to match ce. !15452 (Marc Schwede)
- Rename Approvers field and modal title. !15461
- Add a tooltip to Add Designs button. !15471
- Show the paths for groups in groups dropdown. !15513
- Turn epic dates into one clickable block. !15722 (Lee Tickett)
- Add default route for admin/geo. !15726 (Lee Tickett)
- Improve unapproved MR merge button text. !15745 (Lee Tickett)
- Update the ES indexer to v1.3.0. !15821
- Groups dropdown: Fix group styles in dropdown. !15839
- Document SRV handling for DB load balancing. !16000
- Internationalization of shared/promotions/_promote_audit_events.html.haml. !16033 (Takuya Noguchi)
- Remove vue-resource from service_desk_service.js. !16041 (Lee Tickett)
- Remove unused classes for report comparison. !16045
- Remove vue-resource from related-issues. !16057 (Lee Tickett)
- Add CI variable for repository languages. !16477
- SAST template that doesn't rely on Docker-in-Docker. !16487
- Adding docs for Web IDE Default Commit Options. !16629
- Adding top border back to snippet files. !16709
- Remove vue-resource from drafts. (Lee Tickett)
- Changing instance of key-modern icon to key icon.
- Fixes style-lint errors and warnings for EE builds.scss file.


## 12.2.11

### Fixed (1 change)

- Backport the new reliable fetcher. !21198


## 12.2.8

### Fixed (1 change)

- Geo: LFS not being synced. !17633


## 12.2.7

### Security (1 change)

- Restrict access for security reports in MR widget.


## 12.2.6

### Security (3 changes)

- Hide approvers if a rule has any hidden groups.
- Fix Gitaly SearchBlobs flag RPC injection [Gitaly v1.59.3].
- Prevent IDOR when adding groups to protected environments.


## 12.2.5

### Security (1 change)

- Do not allow creation of projects from group templates if project is not descendant of that group.


## 12.2.4

### Fixed (1 change)

- Fix group hooks not firing in PostReceive. !15598


## 12.2.3

### Security (2 changes)

- Limit number of jobs in running pipelines for the past hour on per plan basis. !1182
- Filter out old system notes for epics in notes api endpoint response.


## 12.2.2

### Security (2 changes)

- Limit number of jobs in running pipelines for the past hour on per plan basis. !1182
- Filter out old system notes for epics in notes api endpoint response.


## 12.2.1

- No changes.

## 12.2.0

### Security (5 changes)

- Gate MR head_pipeline behind read_pipeline ability.
- Queries for Upload should be scoped by model.
- Grant admin note permissions in epics for maintainers and owners.
- Fix bypass email verification when SCIM user is created via API.
- Do not allow localhost urls in GitHub Integration.

### Removed (1 change)

- Removes support for matching on app label for Kubernetes deploy boards, terminals, and pod logs. !14020

### Fixed (67 changes, 2 of them are from the community)

- Fix error when creating issues in scoped boards. !11080
- Resolve Snowplow tracking for notes does not work in Firefox. !12578
- Fix License App user count for ultimate. !14055
- Enable incremental elasticsearch index updates for wikis. !14057
- Ensure U2F javascript runs on GroupSAML callback. !14262
- Fix to allow adding multiple instance-level clusters. !14270
- Initialize chart data in same order as config. !14283
- Make side-nav expanded when on dependency list. !14314
- Add anchor to learn-more-button on the dependency list page so it links to the right location in the docs. !14316
- Un-block UI interactions while Code Quality MR widget is loading. !14323
- Enforce SSO on subgroups and projects. !14364
- Fix race condition on merge train that it cannot process merge request sometimes. !14386
- Fix MWPS/ADMTWPS system notes shows wrong sha. !14397
- Show position of merge trains in system notes. !14398
- Respect limited indexing when importing projects. !14413
- replace dropdown in project cards in Operations Dashboards with a remove icon. !14419
- Allow blank values for IP restriction setting. !14427
- Fix weight quick action to support 0 value. !14432
- Fix cluster health charts on instance level. !14440
- Fix on_environment scope to not re-order whole query. !14481
- Tick instance runner after customer purchases additional CI minutes. !14494
- Fix race condition of `refs/merge` competing overwrite. !14495
- Fix 'learn more'-link on dependency page. !14496
- Allow subgroups to use their parent group's custom project templates. !14499
- Support creating/publishing drafts with commit ID. !14520
- Do not include milestone attribute when promoting issue to epic. !14532
- Include Subgroups in Contribution Analytics calcualtions. !14536
- Fix GeoNode#name backward compatibility. !14564
- Starting a new discussion only on line without Draft note created on it. !14569
- Fix reply to discussion on promoted epic. !14576
- Fix UI breaking on forms on Bootstrap Grid system. !14581 (Takuya Noguchi)
- Geo - Show why node is unhealthy in the rake task to check the health of the secondary node. !14615
- Fix displaying feature flag names in the audit log. !14621
- Support emails as ID in SCIM. !14625
- Fix negative values in burndown charts. !14632
- Fixes #12780 by avoiding incorrect cached values. !14651
- Avoid Design Management thumbnails from being distorted/stretched. !14670
- Support 0 weight in issue sidebar. !14683
- Adds a downard chevron to Dashboards icon in the header. !14711
- Handling use case for repeat trial. !14714
- Fix suggested namespace in deploy boards help text. !14739
- Fix duplicated issues while sorting by weight. !14750 (Vasiliy Yaklushin)
- Resolve Make sure not to redirect to the onboarding welcome page on mobile devices. !14842
- Fix Jira DVCS integration not working when project name has dots. !14855
- Fix the Epics filter bar alignment. !14857
- Fix max attachment size used in CSV export email messages. !14884
- Fix issue that caused the "Merge Immediately" option not to be available when merge trains were enabled. !14894
- Fix error fetching project security dashboard data for maintainers with access to a project but not to its group & fix routing error for project security dashboard for projects not in a group. !14896
- fix: operation dashboard delete icon tooltip title. !14899
- Improve help text and docs about custom metrics. !14912
- Geo - Disable built-in Sidekiq retry for verification workers. !14946
- Remove visual review app feature flag. !14958
- Geo - Warn when reusing an existing tracking database. !14981
- Fix min approvals required for new MR rules. !14988
- Fix admin notes internationalization text. !15001
- Batching minutes reset queries to avoid query timeouts. !15002
- Only show a pull mirror if mirroring is actually enabled. !15049
- Update epic dates when creating an issue that adds the epic using commands. !15062
- Show correct historic max user count for a license. !15107
- Fix job scheduling when extra CI minutes purchased and minutes usage is above application shared Runners minutes limit. !15120
- Skip ES commit results for deleted projects. !15236
- Align "New metric" page title correctly to the rest of the page. !15259
- Bypass push rules for merge to ref service.
- Ensure LDAP Group Sync by Filter normalizes DNs.
- Add support for partial approval in chat message merge request event handler.
- Insights: Only display page config with valid values.
- Shrink empty/loading states for cluster health charts.

### Changed (33 changes, 2 of them are from the community)

- Update merge requests section description text on project settings page. !11098
- First pass at auto remediation changes. !12010
- Create incident issues by default for alerts. !12814
- Resolve Move approval user password input from inline to a modal. !14123
- Add Copy to Clipboard Button to Review App Modal. !14290
- Remove "Allow merge trains" option from project settings page. !14429
- Change epics reordering to not update timestamps. !14441
- Remove feature flag behind MR's multiple assignees. !14506
- Prioritize mirrors for CI over other mirrors. !14575
- Move external authorization service API management to EE. !14598
- Improve default title and description of issues opened from managed Prometheus alerts. !14614
- Add 'Security & Compliance' as top-level navigation item to the project-sidebar. !14628
- Add "Security" as nav-item to group-view sidebar. !14639
- MVC: Group and User Billing Page Improvement - Avatar and Name. !14660 (Ammar Alakkad)
- Geo: Increase HTTP read timeout of proxy requests to 60 s. !14671
- Show threshold in incident title for gitlab alerts. !14688
- Expose licence management reports comparison. !14723
- Move metrics alerts form to modal. !14760
- Add new documentation and link for automating Visual Review feedback. !14789
- Expose licence management report for pipeline. !14796
- Present container scanning report comparison via API. !14898
- Allow approvals_required to be lower than project. !14902
- Rename snowplow_collector_uri to snowplow_collector_hostname. !14963
- Remove duplicated 'New metric' button in prometheus configuration. !14964
- Remove validation of MR level approval rules in merge requests. !14968
- Add missing merge request committer approval setting to API. !15019 (jramsay)
- Move dependency scanning comparision logic to backend. !15023
- Update permissions for Dependency List. !15044
- Dependency List Job Failed Alert - Hide link to job if payload from API does not include 'job_path'. !15068
- Use vulnerability message on Dependency list. !15125
- Rename License Management to License Compliance. !15163
- Elasticsearch: index snippet content only up to 1 MB. !15215
- Add note count, updated timestamp, and closed tag to epics list view.

### Performance (9 changes)

- Remove support for checking legacy security reports. !14291
- Cache Geo checks for a certain time period instead of per request. !14513
- Cache vulnerability history per project. !14619
- Fix N+1 queries in vulnerabilities API. !14638
- Improve Elasticsearch database import by retrying only failed cases first. !14657
- Refactor feature flag scopes for_unleash_client. !14768
- Split MR widget into cached and non-cached serializers. !15045
- Geo: Don't wait when exiting the log cursor. !15070
- Geo: Improve performance of clean up worker for selective sync.

### Added (60 changes, 1 of them is from the community)

- Enabled setting the Security Dashboard as a default view for groups. !7889
- Paginate license management. !10983
- Allows any user to comment on a dismissed vulnerability. !12067
- Enable security gates for merge requests. !13109
- Enable deployment boards and pod logs for instance and group clusters. !13307
- Support for blocking merge requests. !13506
- Add the ability to publish and install NPM packages from groups and subgroups. !13986
- Expose saml_provider_id in the users API. !14045
- Allow adding groups to CODEOWNERS file. !14071
- Add group packages page. !14089
- Add merge train helper text to merge request widget. !14097
- Support remapping of Git repos via SSH with project aliases. !14108
- Allow bulk editing group issues. !14141
- Expose reject_unsigned_commits option via the API. !14165
- Add instance level analytics. !14173
- Show design boards at previous versions. !14292
- Build cascading train refs for parallel execution of Pipelines for merge trains. !14296
- Add notifications for CI Minutes quota limit approaching. !14328
- Require session with smartcard login for Git access. !14368
- Add analytics top navigation link. !14377
- Add Quick Actions for adding/removing epic parent relations. !14451
- Geo: Validate file transfers (attachments, LFS objects, artifacts). !14477
- Create system notes for scoped labels. !14487
- Show deploy boards for group cluster deployments. !14504
- Support feature flag gradualRolloutUserId strategy on backend. !14515
- Add percentage rollout support to feature flag UI. !14538
- Added new Design Management feature for GitLab Premium. With Design Management, you can upload design assets to issues and view them all together to easily share and collaborate with your team. !14582
- Add Ability to Enable Feature Flags by User ID. !14596
- Add ability to view different design versions. !14601
- Allow bulk editing group merge request milestones. !14616
- Add cycle analytics on group level. !14627
- Resolve Add point of interest discussions to designs. !14648
- Limit creation of the Alert Bot in usage ping. !14649
- Audit strategies for feature flag scopes. !14652
- Read and write User Admin notes via API. !14662
- Add date range dropdown for Analytics. !14681
- Allow auditors to see the group and project security dashboards. !14695
- Add `Incident` label to issues created by the Alert Bot. !14705
- Merge vulnerabilities data into Dependency List report. !14706
- Support an alert template field to allow for incident customization. !14710
- Add a rake task to run a LDAP group sync. !14735 (Harish Ramachandran and Cindy Pallares)
- Log impersonation actions in audit log. !14740
- Support feature flag userWithId strategy on backend. !14752
- Add vulnerabilities to dependency list. !14761
- Add project download & project export audit events. !14775
- Count design usage, in order to meet SMAU OKR. !14779
- Support multiple sites in DAST reports. !14787
- Allow adding email domain to group to limit users to ones with email in this particular domain. !14800
- Allow global search on comments. !14818
- Add filtering by vulnerabilities to Dependency List. !14825
- Support for bulk editing labels at a group level. !14827
- Add an Upgrade button to Group's billings page. !14849
- Add authorization to the dependency list. !14867
- Add cycle analytics on a group level - FE. !14891
- Add Dependency Scanning information to the Dependency List. !14955
- Tweak Geo node form text. !14957
- Geo: Make Object Storage synchronization in Geo Nodes configurable via Admin UI. !15000
- Enable security report approvals by default. !15087
- Add Collapse buttons to Operations settings. !15117
- Geo: Support replication for Docker container registries. !15135

### Other (19 changes, 2 of them are from the community)

- Update License Management section information under CI/CD settings. !4295
- Adds a popover to vulnerability-check approvals. !14038
- Show warning for deploy boards if legacy app label is used. !14103
- Change spelling of wildcare to wildcard on feature flag new and edit forms. !14171
- Rename `TOKEN_TYPES` to `USER_TOKEN_TYPES`. !14209 (Arun Kumar Mohan)
- Improved dependency proxy page with some small UI enhancements. !14448
- Replace 'JIRA' with 'Jira' for EE-specific code comments. !14479 (Takuya Noguchi)
- Remove unused EE::GitPushService. !14483
- Improved project level navigation for package features. !14492
- Add Ability to Remove Projects From the Envivonment Dashboard. !14563
- Increase rate at which UpdateAllMirrorsWorker schedules jobs and reschedules itself. !14573
- Cleaned up package list icons to improve consistency inside package section. !14607
- Limit width for onboarding popovers. !14641
- Updates the security dashboard documentation link. !14669
- Add counter columns to geo_node_statuses database table. !14943
- Geo - Rename recheck actions to reverify. !14979
- Remove deprecated name sast_container from licensed features. !14980
- Remove default relative_position from epic_issues. !15008
- Fix alignment of activity dropdown in epic tabs; add counter to discussion tab.


## 12.1.14

### Fixed (1 change)

- Geo: LFS not being synced. !17633


## 12.1.12

### Security (4 changes)

- Hide approvers if a rule has any hidden groups.
- Fix Gitaly SearchBlobs flag RPC injection [Gitaly v1.53.4].
- Prevent IDOR when adding groups to protected environments.
- Upgrade mermaid to prevent XSS.


## 12.1.10

- No changes.

## 12.1.5

- No changes.

## 12.1.4

### Fixed (3 changes)

- Don't send CI usage email notifications when quota is unlimited. !14810
- Fix variable mismatch in code quality widget. !14829
- Change package validation scope to fix Maven package naming functionality. !14922


## 12.1.3

### Fixed (3 changes)

- Allow bulk editing group issues for reporter access level and higher. !14744
- Initialize Application Table on Instance-wide Cluster Details. !14749
- Hide "Buy additional minutes" button for self-managed installs. !14826

### Added (4 changes)

- Add Vulnerabilities API scoping: pipeline. !14376
- Add policy for accessing dependencies. !14561
- Add filtering by package manager for dependencies. !14562
- Add dependency list public endpoint. !14612


## 12.1.2

### Security (1 change)

- Ensure the Insights configuration project is part of the group and is accessible to the current user.

### Security (6 changes)

- Don't override approval rules if not allowed.
- Grant admin note permissions in epics for maintainers and owners.
- Queries for Upload should be scoped by model.
- Fix bypass email verification when SCIM user is created via API.
- Prevent an XSS vector in the add approver email.
- Make vulnerability feedback invisible if limited access to repo.


## 12.1.1

### Fixed (1 change)

- Don't send CI usage email notifications for self-hosted instances. !14809


## 12.0.12

### Fixed (1 change)

- Backport the new reliable fetcher to 12.0.9. !20532


## 12.0.10

- No changes.
### Fixed (1 change)

- Backport the new reliable fetcher to 12.0.9. !20532


## 12.0.7

### Security (3 changes)

- Limit number of jobs in running pipelines for the past hour on per plan basis. !1182
- Queries for Upload should be scoped by model.
- Filter out old system notes for epics in notes api endpoint response.


## 12.0.6

- No changes.

## 12.0.2 (2019-06-25)

### Fixed (1 change)

- Take into account events created before milestone start. !14184


## 12.0.1 (2019-06-24)

- No changes.

## 12.0.0 (2019-06-22)

### Security (2 changes)

- Filter relative links in wiki for XSS.
- Fix XSS in Ancestor tooltip title.

### Removed (2 changes)

- Remove old approver system in favor of new approval rule system. !12436
- Geo: Remove deprecated wikis_count and repositories_count fields from the public API. !13025

### Fixed (36 changes, 1 of them is from the community)

- Group SAML identities cleaned up when leaving a group. !5817
- Make root relative URLs clickable in vulnerability modal. !9767
- Make burndown chart timezone aware. !10328
- Prevent files paths from overflowing in vulnerability info modal. !10606
- Fixed a bug where removing related issues could get stuck. !12316
- Fix anchor link in UI. !12737
- Add feature flag to group_scim javascript. !13078
- Geo - Enable Cron job to perform repository checks on a Geo secondary node. !13103
- Restrict child_epic and remove_child_epic quick actions when using mysql. !13152
- Disable licenses_app feature flag by default. !13291
- Fix security dashboard errors on IE11. !13319
- Respect limited indexing settings in rake tasks. !13437
- Geo - Does not redirect user to the custom home page URL on a Geo secondary. !13447
- Use quarantine size to check push size against repository size limit. !13460
- Fix SSO Enforcement when used with 2FA. !13473
- Fix Git over HTTP when using SAML SSO Enforcement. !13485
- Only use elasticsearch when it is enabled. !13495
- Add referenced-commands in no overflow list. !13550
- Hide action buttons while security dashboard is loading. !13576
- Fix alignment of label for admin notes on admin. !13592 (Takuya Noguchi)
- Use elasticsearch go indexer for wikis. !13743
- Handle case where site property is an array in DAST report. !13775
- Fix dast report parsing regression caused by change in zaproxy. !13789
- Fix port validation in .gitlab-webide.yml. !13846
- Fix "rule_type does not exist" error during consume_remaining_migrate_approver_to_approval_rules_in_batch_jobs migration. !13947
- Hide operations nav icon for small screens. !13960
- Remove free user info from non-ultimate license. !14010
- Use fallback approval rule if no eligible rules exist. !14042
- Fix 'Group > Usage Quota' menu item. !14043
- Fix incorrect epic ancestor links. !14092
- Show Usage Quotas regardless of namespace subscription. !14135
- Fix calculation of used extra CI minutes. !14217
- Remove class hiding spinner in board switcher.
- Fix broken filter by approvers.
- Remove extra spaces in MR list view approval counts.
- Remove extra border on tracing empty state page.

### Changed (18 changes)

- Allow merge requests to be merged even when it does not have up-to-date pipeline when merge request pipeline is enabled. !12309
- Migrate code_owners to rule_type enum on approval_merge_request_rules. !13036
- Avoid failing pull mirroring if LFS import fails. !13133
- Updates Pipeline Quota page to accomodate for Storage Quotas. !13139
- Align group and project level security dashboard UX. !13180
- Remove shared_runner_minutes_on_root_namespace feature flag. !13208
- Enable dependency proxy per group by default. !13574
- Move dependencies API endpoint to "security" namespace. !13897
- Allow developers to configure dependency proxy. !13899
- Use real data in `:project/security/dependencies` endpoint. !13906
- Use bulk-indexing API for project associations. !13917
- Update response schema for DependencyList endpoint and add status. !13918
- Geo - Make foreign data wrapper a hard requirement. !13940
- Polish SAML SSO configuration page. !13982
- Make Insights Generally Available. !14067
- Automatically index wikis in elasticsearch. !14095
- Require Hashed Storage to be enabled to create new Geo Nodes. !14102
- Changes to default insights charts.

### Performance (7 changes)

- Omit page counts in admin audit logs. !1306
- Improve scheduling of mirror updates to reduce frequency of database queries. !11217
- Limit count to improve query performance. !12231
- Avoid loading database objects for Elasticsearch results. !12691
- Avoid hitting Elasticsearch more than once on search. !13120
- Add index to count pending mirror updates. !13901
- Performance improvement when loading epics list. !13904

### Added (34 changes, 1 of them is from the community)

- Provide application-wide LDAP membership lock setting. !4354
- Added a "Require user password to approve" option on projects for merge request approvals to enable compliance in FDA regulated fields". !10364 (James Davila, Paul Knopf, Greg Smethells)
- Add "Allow merge trains" option to project settings page. !10803
- Add optional reason when dismissing vulnerabilities. !11226
- System notes for adding and removing epic relationships. !11416
- Show if user is using a license seat on admin user page. !11449
- Allow merge requests to block other MRs from being merged. !11600
- SSO enforement redirects to group sign in when not using SAML. !12246
- When a merge request is blocked by other unmerged merge requests, display them on the show page of a merge request. !12357
- Group SAML can be used to sign into a GitLab instance. !12660
- IP address restriction for groups. !12669
- Make the number of Elasticsearch shards and replicas configurable. !12713
- Add quick actions for adding and removing child epic relations to epic. !12772
- Adds a confidence filter to the Group Security Dashboard. !12805
- Expose Design blobs through GraphQL. !13037
- Expand pipeline variables passed downstream. !13197
- Add support for querying epics with GraphQL. !13248
- Add Merge Train auto merge strategy. !13278
- Adds Storage Counter. !13294
- Allow design blobs to be stored in Git LFS. !13389
- JIT users provisioning for group SAML. !13552
- Add Ability for Maintainers to Rotate Instance Id in Feature Flags. !13722
- Notify users when their CI minutes quota has run out. !13735
- Use Flipper as an A/B testing framework. !13755
- [New Auto Merge Strategy] Add To Merge Train When Pipeline Succeeds. !13767
- Add `dependency_list` report. !13900
- Add admin form to enforce a pipeline on an instance. !13923
- Count usage of DependencyList endpoint. !13962
- Add preliminary Dependency List frontend implementation. !13968
- Add Admin settings to disable project deletion. !14002
- Usage ping: Track amount of incident issues. !14013
- Sync file changes from Web IDE to Web Terminal. !14035
- Add report_approver to approval_merge_request_rules. !14050
- Add merge train position message under pipeline in merge request widget. !14064

### Other (9 changes, 2 of them are from the community)

- New user flow for SSOing into a GitLab.com group. !10338
- Improve vulnerability API. !12760 (Robert Schilling)
- Add action popover component for user onboarding. !13346
- Add help content popover component for user onboarding. !13363
- Expose services in the web ide terminal entity. !13665
- Rename boards spec name. !13725 (George Tsiolis)
- Fix typos in i18n strings for onboarding tour. !14153
- Externalize strings of chat page in user profile. !28632
- Remove commit count from storage quotass.
