=begin
#Error Trackig REST API

#This schema describes the API endpoints for the error tracking feature

The version of the OpenAPI document: 0.0.1

Generated by: https://openapi-generator.tech
OpenAPI Generator version: 6.0.0

=end

require 'cgi'

module ErrorTrackingOpenAPI
  class EventsApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # Get information about the events related to the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error within the project
    # @param [Hash] opts the optional parameters
    # @option opts [String] :sort  (default to 'occurred_at_asc')
    # @option opts [String] :cursor Base64 encoded information for pagination
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<ErrorEvent>]
    def list_events(project_id, fingerprint, opts = {})
      data, _status_code, _headers = list_events_with_http_info(project_id, fingerprint, opts)
      data
    end

    # Get information about the events related to the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error within the project
    # @param [Hash] opts the optional parameters
    # @option opts [String] :sort  (default to 'occurred_at_asc')
    # @option opts [String] :cursor Base64 encoded information for pagination
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<(Array<ErrorEvent>, Integer, Hash)>] Array<ErrorEvent> data, response status code and response headers
    def list_events_with_http_info(project_id, fingerprint, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: EventsApi.list_events ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling EventsApi.list_events"
      end
      # verify the required parameter 'fingerprint' is set
      if @api_client.config.client_side_validation && fingerprint.nil?
        fail ArgumentError, "Missing the required parameter 'fingerprint' when calling EventsApi.list_events"
      end
      allowable_values = ["occurred_at_asc", "occurred_at_desc"]
      if @api_client.config.client_side_validation && opts[:'sort'] && !allowable_values.include?(opts[:'sort'])
        fail ArgumentError, "invalid value for \"sort\", must be one of #{allowable_values}"
      end
      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] > 100
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling EventsApi.list_events, must be smaller than or equal to 100.'
      end

      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] < 1
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling EventsApi.list_events, must be greater than or equal to 1.'
      end

      # resource path
      local_var_path = '/projects/{projectId}/errors/{fingerprint}/events'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s)).sub('{' + 'fingerprint' + '}', CGI.escape(fingerprint.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'sort'] = opts[:'sort'] if !opts[:'sort'].nil?
      query_params[:'cursor'] = opts[:'cursor'] if !opts[:'cursor'].nil?
      query_params[:'limit'] = opts[:'limit'] if !opts[:'limit'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<ErrorEvent>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"EventsApi.list_events",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: EventsApi#list_events\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Ingestion endpoint for error events sent from client SDKs
    # @param project_id [Integer] ID of the project where the error was created
    # @param [Hash] opts the optional parameters
    # @return [ErrorEvent]
    def projects_api_project_id_envelope_post(project_id, opts = {})
      data, _status_code, _headers = projects_api_project_id_envelope_post_with_http_info(project_id, opts)
      data
    end

    # Ingestion endpoint for error events sent from client SDKs
    # @param project_id [Integer] ID of the project where the error was created
    # @param [Hash] opts the optional parameters
    # @return [Array<(ErrorEvent, Integer, Hash)>] ErrorEvent data, response status code and response headers
    def projects_api_project_id_envelope_post_with_http_info(project_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: EventsApi.projects_api_project_id_envelope_post ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling EventsApi.projects_api_project_id_envelope_post"
      end
      # resource path
      local_var_path = '/projects/api/{projectId}/envelope'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'ErrorEvent'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"EventsApi.projects_api_project_id_envelope_post",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: EventsApi#projects_api_project_id_envelope_post\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Ingestion endpoint for error events sent from client SDKs
    # @param project_id [Integer] ID of the project where the error was created
    # @param [Hash] opts the optional parameters
    # @return [ErrorEvent]
    def projects_api_project_id_store_post(project_id, opts = {})
      data, _status_code, _headers = projects_api_project_id_store_post_with_http_info(project_id, opts)
      data
    end

    # Ingestion endpoint for error events sent from client SDKs
    # @param project_id [Integer] ID of the project where the error was created
    # @param [Hash] opts the optional parameters
    # @return [Array<(ErrorEvent, Integer, Hash)>] ErrorEvent data, response status code and response headers
    def projects_api_project_id_store_post_with_http_info(project_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: EventsApi.projects_api_project_id_store_post ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling EventsApi.projects_api_project_id_store_post"
      end
      # resource path
      local_var_path = '/projects/api/{projectId}/store'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'ErrorEvent'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"EventsApi.projects_api_project_id_store_post",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: EventsApi#projects_api_project_id_store_post\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
