=begin
#Error Trackig REST API

#This schema describes the API endpoints for the error tracking feature

The version of the OpenAPI document: 0.0.1

Generated by: https://openapi-generator.tech
OpenAPI Generator version: 6.0.0

=end

require 'cgi'

module ErrorTrackingOpenAPI
  class ErrorsApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # Get information about the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error that needs to be updated deleted
    # @param [Hash] opts the optional parameters
    # @return [Error]
    def get_error(project_id, fingerprint, opts = {})
      data, _status_code, _headers = get_error_with_http_info(project_id, fingerprint, opts)
      data
    end

    # Get information about the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error that needs to be updated deleted
    # @param [Hash] opts the optional parameters
    # @return [Array<(Error, Integer, Hash)>] Error data, response status code and response headers
    def get_error_with_http_info(project_id, fingerprint, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsApi.get_error ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling ErrorsApi.get_error"
      end
      # verify the required parameter 'fingerprint' is set
      if @api_client.config.client_side_validation && fingerprint.nil?
        fail ArgumentError, "Missing the required parameter 'fingerprint' when calling ErrorsApi.get_error"
      end
      # resource path
      local_var_path = '/projects/{projectId}/errors/{fingerprint}'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s)).sub('{' + 'fingerprint' + '}', CGI.escape(fingerprint.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Error'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsApi.get_error",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsApi#get_error\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List of errors
    # @param project_id [Integer] ID of the project where the error was created
    # @param [Hash] opts the optional parameters
    # @option opts [String] :sort  (default to 'last_seen_desc')
    # @option opts [String] :status  (default to 'unresolved')
    # @option opts [String] :query 
    # @option opts [String] :cursor Base64 encoded information for pagination
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<Error>]
    def list_errors(project_id, opts = {})
      data, _status_code, _headers = list_errors_with_http_info(project_id, opts)
      data
    end

    # List of errors
    # @param project_id [Integer] ID of the project where the error was created
    # @param [Hash] opts the optional parameters
    # @option opts [String] :sort  (default to 'last_seen_desc')
    # @option opts [String] :status  (default to 'unresolved')
    # @option opts [String] :query 
    # @option opts [String] :cursor Base64 encoded information for pagination
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<(Array<Error>, Integer, Hash)>] Array<Error> data, response status code and response headers
    def list_errors_with_http_info(project_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsApi.list_errors ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling ErrorsApi.list_errors"
      end
      allowable_values = ["last_seen_desc", "first_seen_desc", "frequency_desc"]
      if @api_client.config.client_side_validation && opts[:'sort'] && !allowable_values.include?(opts[:'sort'])
        fail ArgumentError, "invalid value for \"sort\", must be one of #{allowable_values}"
      end
      allowable_values = ["unresolved", "resolved", "ignored"]
      if @api_client.config.client_side_validation && opts[:'status'] && !allowable_values.include?(opts[:'status'])
        fail ArgumentError, "invalid value for \"status\", must be one of #{allowable_values}"
      end
      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] > 100
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling ErrorsApi.list_errors, must be smaller than or equal to 100.'
      end

      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] < 1
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling ErrorsApi.list_errors, must be greater than or equal to 1.'
      end

      # resource path
      local_var_path = '/projects/{projectId}/errors'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'sort'] = opts[:'sort'] if !opts[:'sort'].nil?
      query_params[:'status'] = opts[:'status'] if !opts[:'status'].nil?
      query_params[:'query'] = opts[:'query'] if !opts[:'query'].nil?
      query_params[:'cursor'] = opts[:'cursor'] if !opts[:'cursor'].nil?
      query_params[:'limit'] = opts[:'limit'] if !opts[:'limit'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<Error>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsApi.list_errors",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsApi#list_errors\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Get information about the events related to the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error within the project
    # @param [Hash] opts the optional parameters
    # @option opts [String] :sort  (default to 'occurred_at_asc')
    # @option opts [String] :cursor Base64 encoded information for pagination
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<ErrorEvent>]
    def list_events(project_id, fingerprint, opts = {})
      data, _status_code, _headers = list_events_with_http_info(project_id, fingerprint, opts)
      data
    end

    # Get information about the events related to the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error within the project
    # @param [Hash] opts the optional parameters
    # @option opts [String] :sort  (default to 'occurred_at_asc')
    # @option opts [String] :cursor Base64 encoded information for pagination
    # @option opts [Integer] :limit Number of entries to return (default to 20)
    # @return [Array<(Array<ErrorEvent>, Integer, Hash)>] Array<ErrorEvent> data, response status code and response headers
    def list_events_with_http_info(project_id, fingerprint, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsApi.list_events ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling ErrorsApi.list_events"
      end
      # verify the required parameter 'fingerprint' is set
      if @api_client.config.client_side_validation && fingerprint.nil?
        fail ArgumentError, "Missing the required parameter 'fingerprint' when calling ErrorsApi.list_events"
      end
      allowable_values = ["occurred_at_asc", "occurred_at_desc"]
      if @api_client.config.client_side_validation && opts[:'sort'] && !allowable_values.include?(opts[:'sort'])
        fail ArgumentError, "invalid value for \"sort\", must be one of #{allowable_values}"
      end
      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] > 100
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling ErrorsApi.list_events, must be smaller than or equal to 100.'
      end

      if @api_client.config.client_side_validation && !opts[:'limit'].nil? && opts[:'limit'] < 1
        fail ArgumentError, 'invalid value for "opts[:"limit"]" when calling ErrorsApi.list_events, must be greater than or equal to 1.'
      end

      # resource path
      local_var_path = '/projects/{projectId}/errors/{fingerprint}/events'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s)).sub('{' + 'fingerprint' + '}', CGI.escape(fingerprint.to_s))

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'sort'] = opts[:'sort'] if !opts[:'sort'].nil?
      query_params[:'cursor'] = opts[:'cursor'] if !opts[:'cursor'].nil?
      query_params[:'limit'] = opts[:'limit'] if !opts[:'limit'].nil?

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['*/*'])

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type] || 'Array<ErrorEvent>'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsApi.list_events",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsApi#list_events\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update the status of the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error that needs to be updated deleted
    # @param body [ErrorUpdatePayload] Error update object with the new values
    # @param [Hash] opts the optional parameters
    # @return [Error]
    def update_error(project_id, fingerprint, body, opts = {})
      data, _status_code, _headers = update_error_with_http_info(project_id, fingerprint, body, opts)
      data
    end

    # Update the status of the error
    # @param project_id [Integer] ID of the project where the error was created
    # @param fingerprint [Integer] ID of the error that needs to be updated deleted
    # @param body [ErrorUpdatePayload] Error update object with the new values
    # @param [Hash] opts the optional parameters
    # @return [Array<(Error, Integer, Hash)>] Error data, response status code and response headers
    def update_error_with_http_info(project_id, fingerprint, body, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: ErrorsApi.update_error ...'
      end
      # verify the required parameter 'project_id' is set
      if @api_client.config.client_side_validation && project_id.nil?
        fail ArgumentError, "Missing the required parameter 'project_id' when calling ErrorsApi.update_error"
      end
      # verify the required parameter 'fingerprint' is set
      if @api_client.config.client_side_validation && fingerprint.nil?
        fail ArgumentError, "Missing the required parameter 'fingerprint' when calling ErrorsApi.update_error"
      end
      # verify the required parameter 'body' is set
      if @api_client.config.client_side_validation && body.nil?
        fail ArgumentError, "Missing the required parameter 'body' when calling ErrorsApi.update_error"
      end
      # resource path
      local_var_path = '/projects/{projectId}/errors/{fingerprint}'.sub('{' + 'projectId' + '}', CGI.escape(project_id.to_s)).sub('{' + 'fingerprint' + '}', CGI.escape(fingerprint.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Accept' (if needed)
      header_params['Accept'] = @api_client.select_header_accept(['application/json'])
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(body)

      # return_type
      return_type = opts[:debug_return_type] || 'Error'

      # auth_names
      auth_names = opts[:debug_auth_names] || ['internalToken']

      new_options = opts.merge(
        :operation => :"ErrorsApi.update_error",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:PUT, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: ErrorsApi#update_error\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
