# frozen_string_literal: true

require "spec_helper"

require_migration!

RSpec.describe ScheduleMigrateSharedVulnerabilityIdentifiers, :migration, feature_category: :vulnerability_management do
  describe "#up" do
    before do
      migrate!
    end

    it "schedules" do
      Gitlab::Database::BackgroundMigration::BatchedMigration.find_by!(
        job_class_name: described_class::MIGRATION,
        table_name: described_class::TABLE_NAME,
        column_name: described_class::BATCH_COLUMN,
        batch_size: described_class::BATCH_SIZE,
        sub_batch_size: described_class::SUB_BATCH_SIZE)
    end
  end

  describe '#down' do
    before do
      schema_migrate_down!
    end

    it "deletes" do
      expect(described_class::MIGRATION).not_to have_scheduled_batched_migration
    end
  end
end
