# frozen_string_literal: true

require "spec_helper"

require_migration!

RSpec.describe AddTmpPartialIndexOnVulnerabilityReportTypes2, feature_category: :vulnerability_management do
  let(:async_index) { Gitlab::Database::AsyncIndexes::PostgresAsyncIndex }
  let(:index_name) { described_class::INDEX_NAME }

  before do
    allow_any_instance_of(ActiveRecord::ConnectionAdapters::SchemaStatements) # rubocop:disable RSpec/AnyInstanceOf
      .to receive(:index_exists?)
            .with("vulnerability_occurrences", :id, hash_including(name: index_name))
            .and_return(index_exists)
  end

  context "with index absent" do
    let(:index_exists) { false }

    it "schedules the index" do
      reversible_migration do |migration|
        migration.before -> do
          expect(async_index.where(name: index_name).count).to be(0)
        end

        migration.after -> do
          expect(async_index.where(name: index_name).count).to be(1)
        end
      end
    end
  end

  context "with index present" do
    let(:index_exists) { true }

    it "does not schedule the index" do
      reversible_migration do |migration|
        migration.before -> do
          expect(async_index.where(name: index_name).count).to be(0)
        end

        migration.after -> do
          expect(async_index.where(name: index_name).count).to be(0)
        end
      end
    end
  end
end
