# frozen_string_literal: true

module QA
  module EE
    module Resource
      class VulnerabilityReport
        SEVERITY_ARRAY = %i[CRITICAL LOW MEDIUM HIGH UNKNOWN INFO].freeze

        def create_vuln_report(project_id, count = 2)
          count.times do
            QA::EE::Resource::VulnerabilityItem.fabricate_via_api! do |var|
              var.id = project_id
              var.severity = SEVERITY_ARRAY.sample
            end
          end
        end
      end
    end
  end
end
