# frozen_string_literal: true

module QA
  module EE
    module Page
      module Project
        module Secure
          class VulnerabilityDetails < QA::Page::Base
            view 'ee/app/assets/javascripts/vulnerabilities/components/header.vue' do
              element :vulnerability_header
            end

            view 'ee/app/assets/javascripts/vulnerabilities/components/vulnerability_details.vue' do
              element :vulnerability_details
              element :vulnerability_title
              element :vulnerability_description
            end

            view 'ee/app/assets/javascripts/vulnerabilities/components/footer.vue' do
              element :vulnerability_footer
            end

            view 'ee/app/assets/javascripts/vulnerabilities/components/related_issues.vue' do
              element :create_issue_button
            end

            view 'ee/app/assets/javascripts/vulnerabilities/components/false_positive_alert.vue' do
              element :false_positive_alert
            end

            view 'ee/app/assets/javascripts/vulnerabilities/components/vulnerability_state_dropdown.vue' do
              element :vulnerability_status_dropdown
              element :vulnerability_save_status_button
              element :dismissal_reason_dropdown
            end

            view 'ee/app/assets/javascripts/vulnerabilities/components/related_jira_issues.vue' do
              element :create_new_jira_issue_button
              element :jira_issue_link
            end

            def has_component?(component_name:)
              has_element?(component_name.to_sym)
            end

            def has_vulnerability_title?(title:)
              has_element?(:vulnerability_title, text: title)
            end

            def has_vulnerability_description?(description:)
              has_element?(:vulnerability_description, text: description)
            end

            def click_create_issue_button
              click_element(:create_issue_button)
            end

            def click_create_jira_issue_button
              click_element(:create_new_jira_issue_button)
            end

            def change_status(status)
              click_element(:vulnerability_status_dropdown)
              click_element("vulnerability_state_#{status}")

              choose_dismissal_reason if status == 'dismissed'

              click_element(:vulnerability_save_status_button)
            end

            def choose_dismissal_reason
              reasons = ['Acceptable risk', 'False positive', 'Mitigating control', 'Used in tests', 'Not applicable']
              return unless has_element?(:dismissal_reason_dropdown)

              find_element(:dismissal_reason_dropdown).find('li', text: reasons.sample).click
            end

            def has_vulnerability_status?(status)
              has_element?(:vulnerability_status_dropdown, text: "#{status.capitalize}")
            end

            def jira_issue_link_present?(issue_text, jira_issue_url, issue_key)
              element = find_element(:jira_issue_link, issue_key: issue_key)
              element.text == issue_text && element["href"].include?(jira_issue_url)
            end
          end
        end
      end
    end
  end
end
