# frozen_string_literal: true

require 'spec_helper'

RSpec.describe Gitlab::Vulnerabilities::BaseVulnerability, feature_category: :vulnerability_management do
  let(:data) do
    {
      title: 'title',
      description: 'desc',
      severity: 'high',
      confidence: 'low',
      identifiers: [
        {
          type: 'CVE',
          name: 'CVE-2017-15650',
          value: 'CVE-2017-15650',
          url: 'https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2017-15650'
        }
      ],
      links: [{ name: 'Awesome-security blog post', url: 'https;//example.com/blog-post' }],
      location: { file: 'main.rb', start_line: 14, blob_path: '/bar/foo/main.rb#14' },
      solution: 'upgrade dependencies',
      scanner: { external_id: 'gemnasium', name: 'Gemnasium' },
      scan: { type: 'dependency_scanning', status: 'success', start_time: 'placeholder', end_time: 'placeholder' }
    }
  end

  let(:vulnerability) { described_class.new(data) }

  where(:getter) { %w[title description] }

  with_them do
    it 'raises an error' do
      expect { vulnerability.public_send(getter) }.to raise_error(NotImplementedError)
    end
  end

  describe 'getters' do
    where(:getter) { %i[severity confidence solution identifiers links remediations target_branch scan scanner] }

    let(:with_nil) { described_class.new({}) }

    with_them do
      it 'returns right value' do
        expect(vulnerability.public_send(getter)).to eq(data[getter])
      end

      it 'returns nil value' do
        expect(with_nil.public_send(getter)).to eq(nil)
      end
    end
  end
end
