import { GlTabs } from '@gitlab/ui';
import VulnerabilityReportLayout from 'ee/security_dashboard/components/shared/vulnerability_report_layout.vue';
import { shallowMountExtended } from 'helpers/vue_test_utils_helper';
import { DASHBOARD_TYPES } from 'ee/security_dashboard/store/constants';

describe('Vulnerability Report Layout component', () => {
  let wrapper;
  const SMALLER_SECTION_CLASS = 'col-xl-7';

  const DummyComponent = {
    name: 'dummy-component',
    template: '<p>dummy component</p>',
  };

  const createWrapper = ({ slots, provide } = {}) => {
    wrapper = shallowMountExtended(VulnerabilityReportLayout, {
      slots,
      provide: {
        dashboardType: DASHBOARD_TYPES.PROJECT,
        ...provide,
      },
    });
  };

  const findArticle = () => wrapper.find('article');
  const findHeader = () => wrapper.find('header');
  const findStickySection = () => wrapper.findByTestId('sticky-section');
  const findSummarySection = () => wrapper.findByTestId('summary-section');
  const findTabs = () => wrapper.findComponent(GlTabs);

  describe('template slots', () => {
    it('should not render any slot contents by default', () => {
      createWrapper();

      expect(findHeader().exists()).toBe(false);
      expect(findStickySection().exists()).toBe(false);
      expect(findSummarySection().exists()).toBe(false);
      expect(findArticle().classes()).not.toContain(SMALLER_SECTION_CLASS);
    });

    it.each`
      slotName     | findFn
      ${'default'} | ${findArticle}
      ${'header'}  | ${findHeader}
      ${'sticky'}  | ${findStickySection}
      ${'summary'} | ${findSummarySection}
    `('should render the template contents in the correct slot', ({ slotName, findFn }) => {
      createWrapper({
        slots: {
          [slotName]: DummyComponent,
        },
      });

      expect(findFn().findComponent(DummyComponent).exists()).toBe(true);
    });
  });

  describe('tabs', () => {
    it.each`
      test                                                        | dashboardType               | exists
      ${'should not find the tabs for the pipeline-level report'} | ${DASHBOARD_TYPES.PIPELINE} | ${false}
      ${'should find the tabs for the project-level report'}      | ${DASHBOARD_TYPES.PROJECT}  | ${true}
      ${'should find the tabs for the group-level report'}        | ${DASHBOARD_TYPES.GROUP}    | ${true}
      ${'should find the tabs for the instance-level report'}     | ${DASHBOARD_TYPES.INSTANCE} | ${true}
    `('$test', ({ exists, dashboardType }) => {
      createWrapper({ provide: { dashboardType } });
      expect(findTabs().exists()).toBe(exists);
    });
  });
});
